/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

public class OperationDescriptor extends DescriptorElement {

  private final String method;
  private final String name;
  private final String description;
  private final String inputMediaType;
  private final String outputMediaType;
  private final RequestDescriptor expects;
  private final Boolean ignored;
  private final String baseUri;
  private final String pagination;
  private final Boolean skipOutputTypeValidation;
  private final Boolean voidOperation;
  private final String inputTypeSchema;
  private final String outputTypeSchema;
  private final String queryParamArrayFormat;

  public OperationDescriptor(String method, String name, String description, String inputMediaType, String outputMediaType,
                             RequestDescriptor expects, Boolean ignored, String alternativeBaseUri, String pagination,
                             Boolean skipOutputTypeValidation, Boolean voidOperation, String inputTypeSchema,
                             String outputTypeSchema, String queryParamArrayFormat) {
    this.method = method;
    this.name = name;
    this.description = description;
    this.inputMediaType = inputMediaType;
    this.outputMediaType = outputMediaType;
    this.expects = expects;
    this.ignored = ignored;
    this.baseUri = alternativeBaseUri;
    this.pagination = pagination;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.voidOperation = voidOperation;
    this.inputTypeSchema = inputTypeSchema;
    this.outputTypeSchema = outputTypeSchema;
    this.queryParamArrayFormat = queryParamArrayFormat;
  }

  public String getMethod() {
    return method;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getInputMediaType() {
    return inputMediaType;
  }

  public String getOutputMediaType() {
    return outputMediaType;
  }

  public RequestDescriptor getExpects() {
    return expects;
  }

  public Boolean isIgnored() {
    return ignored;
  }

  public String getBaseUri() {
    return baseUri;
  }

  public String getPagination() {
    return pagination;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public Boolean getVoidOperation() {
    return voidOperation;
  }

  public String getInputTypeSchema() {
    return inputTypeSchema;
  }

  public String getOutputTypeSchema() {
    return outputTypeSchema;
  }

  public String getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }
}
