/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

public class PartDescriptor extends DescriptorElement {

  private final String friendlyName;
  private final String partName;
  private final String description;
  private final String inputType;
  private final String contentType;
  private final boolean isFilePart;

  public PartDescriptor(String partName, String friendlyName, String description, String inputType, String contentType,
                        boolean isFilePart) {

    this.partName = partName;
    this.friendlyName = friendlyName;
    this.description = description;
    this.inputType = inputType;
    this.contentType = contentType;
    this.isFilePart = isFilePart;
  }

  public String getFriendlyName() {
    return friendlyName;
  }

  public String getPartName() {
    return partName;
  }

  public String getDescription() {
    return description;
  }

  public String getInputType() {
    return inputType;
  }

  public String getContentType() {
    return contentType;
  }

  public boolean isFilePart() {
    return isFilePart;
  }

}
