/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

/**
 * Descriptor element that allows defining an instance of a trigger that must be generated in the connector.
 */
public class TriggerDescriptor extends DescriptorElement {

  private final String name;
  private final String path;
  private final HttpMethodDescriptor method;
  private final String displayName;
  private final String description;
  private final List<TriggerParameterDescriptor> parameters;
  private final TriggerParameterBindingsDescriptor parameterBindings;
  private final TriggerWatermarkDescriptor watermark;
  private final String itemsExpression;
  private final String identityExpression;

  public TriggerDescriptor(String name, String path, HttpMethodDescriptor method, String displayName, String description,
                           List<TriggerParameterDescriptor> parameters, TriggerParameterBindingsDescriptor parameterBindings,
                           TriggerWatermarkDescriptor watermark, String itemsExpression, String identityExpression) {
    this.name = name;
    this.path = path;
    this.method = method;
    this.displayName = displayName;
    this.description = description;
    this.parameters = parameters;
    this.parameterBindings = parameterBindings;
    this.watermark = watermark;
    this.itemsExpression = itemsExpression;
    this.identityExpression = identityExpression;
  }

  public String getName() {
    return name;
  }

  public String getPath() {
    return path;
  }

  public HttpMethodDescriptor getMethod() {
    return method;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getDescription() {
    return description;
  }

  public List<TriggerParameterDescriptor> getParameters() {
    return parameters;
  }

  public TriggerParameterBindingsDescriptor getParameterBindings() {
    return parameterBindings;
  }

  public TriggerWatermarkDescriptor getWatermark() {
    return watermark;
  }

  public String getItemsExpression() {
    return itemsExpression;
  }

  public String getIdentityExpression() {
    return identityExpression;
  }
}
