/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

public class TriggerParameterDescriptor {

  private final String name;
  private final String displayName;
  private final String description;
  private final DataTypeDescriptor dataType;
  private final boolean required;

  public TriggerParameterDescriptor(String name, String displayName, String description, DataTypeDescriptor dataType,
                                    boolean required) {
    this.name = name;
    this.displayName = displayName;
    this.description = description;
    this.dataType = dataType;
    this.required = required;
  }

  public String getName() {
    return name;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getDescription() {
    return description;
  }

  public DataTypeDescriptor getDataType() {
    return dataType;
  }

  public boolean isRequired() {
    return required;
  }
}
