/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import java.util.List;

/*
 This class describes how the parameter values that must be sent to the server by a value resolver are generated.
 */
public class ValueResolverBindingDescriptor {

  private final List<ValueResolverBindingParameterDescriptor> uriParameters;
  private final List<ValueResolverBindingParameterDescriptor> queryParameters;
  private final List<ValueResolverBindingParameterDescriptor> headers;

  public ValueResolverBindingDescriptor(
                                        List<ValueResolverBindingParameterDescriptor> uriParameters,
                                        List<ValueResolverBindingParameterDescriptor> queryParameters,
                                        List<ValueResolverBindingParameterDescriptor> headers) {
    this.uriParameters = uriParameters;
    this.queryParameters = queryParameters;
    this.headers = headers;
  }

  public List<ValueResolverBindingParameterDescriptor> getUriParameters() {
    return uriParameters;
  }

  public List<ValueResolverBindingParameterDescriptor> getQueryParameters() {
    return queryParameters;
  }

  public List<ValueResolverBindingParameterDescriptor> getHeaders() {
    return headers;
  }
}
