/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

/*
 This class describes how to generate the value for a parameter that will be sent to the server by a value
 resolver when looking for the possible values.
 */
public class ValueResolverBindingParameterDescriptor {

  private final String name;
  private final ExpressionDescriptor value;

  public ValueResolverBindingParameterDescriptor(String name,
                                                 ExpressionDescriptor value) {
    this.name = name;
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public ExpressionDescriptor getValue() {
    return value;
  }
}
