/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

/*
 This class describes how the actual items (values) for a value provider are extracted and parsed by the value resolver.
 */
public class ValueResolverItemsDescriptor {

  private final ExpressionDescriptor extraction;
  private final ExpressionDescriptor value;
  private final ExpressionDescriptor displayName;

  public ValueResolverItemsDescriptor(ExpressionDescriptor extraction,
                                      ExpressionDescriptor value,
                                      ExpressionDescriptor displayName) {
    this.extraction = extraction;
    this.value = value;
    this.displayName = displayName;
  }

  public ExpressionDescriptor getExtraction() {
    return extraction;
  }

  public ExpressionDescriptor getValue() {
    return value;
  }

  public ExpressionDescriptor getDisplayName() {
    return displayName;
  }
}
