/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseAlternativeBaseUri;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseApiContractPath;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseNullableIgnore;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

class DescriptorEndpointParser {

  private static final String API_CONTRACT_ENDPOINT = "http://a.ml/vocabularies.rest.sdk/apiContract#endpoint";

  private final DescriptorOperationParser descriptorOperationParser = new DescriptorOperationParser();

  public List<EndPointDescriptor> parseEndpoints(DialectDomainElement encodes, Path descriptorFilePath)
      throws ModelGenerationException {
    List<EndPointDescriptor> endpointDescriptors = new ArrayList<>();

    for (DialectDomainElement x : getEndpoints(encodes)) {
      endpointDescriptors.add(parseEndpoint(x, descriptorFilePath));
    }

    return endpointDescriptors;
  }

  private EndPointDescriptor parseEndpoint(DialectDomainElement endpointElement, Path descriptorFilePath)
      throws ModelGenerationException {
    return new EndPointDescriptor(
                                  parseApiContractPath(endpointElement),
                                  descriptorOperationParser.parseOperations(endpointElement, descriptorFilePath),
                                  parseNullableIgnore(endpointElement),
                                  parseAlternativeBaseUri(endpointElement));
  }

  private List<DialectDomainElement> getEndpoints(DialectDomainElement encodes) {
    return encodes.getObjectPropertyUri(API_CONTRACT_ENDPOINT);
  }

}
