/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleStringProperty;

public class DescriptorMavenGavParser {

  private final static String REST_SDK_CONNECTOR_GAV = "http://a.ml/vocabularies/rest-sdk#connectorGav";
  private final static String ANYPOINT_TENANT_ID = "http://anypoint.com/vocabs/anypoint#tenantId";
  private final static String DIGITAL_REPOSITORY_ARTIFACT_ID = "http://anypoint.com/vocabs/digital-repository#assetId";
  private final static String SCHEMA_ORG_VERSION = "http://anypoint.com/vocabs/schema-org#version";

  public MavenGavDescriptor parseMavenGav(DialectDomainElement mavenGavElement) {
    if (mavenGavElement == null) {
      return null;
    }

    return new MavenGavDescriptor(
                                  parseGroupId(mavenGavElement),
                                  parseArtifactId(mavenGavElement),
                                  parseVersion(mavenGavElement));
  }

  public DialectDomainElement parseConnectorGavElement(DialectDomainElement encodes) {
    return getSingleObjectProperty(encodes, REST_SDK_CONNECTOR_GAV);
  }

  private String parseGroupId(DialectDomainElement mavenGavElement) {
    return parseSingleStringProperty(mavenGavElement, ANYPOINT_TENANT_ID);
  }

  private String parseArtifactId(DialectDomainElement mavenGavElement) {
    return parseSingleStringProperty(mavenGavElement, DIGITAL_REPOSITORY_ARTIFACT_ID);
  }

  private String parseVersion(DialectDomainElement mavenGavElement) {
    return parseSingleStringProperty(mavenGavElement, SCHEMA_ORG_VERSION);
  }

}
