/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;

import java.util.List;

import static java.util.stream.Collectors.toList;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.*;

public class DescriptorParameterParser {

  private static final DescriptorValueResolverReferenceParser valueResolverReferenceParser =
      new DescriptorValueResolverReferenceParser();

  public List<ParameterDescriptor> parseParameters(List<DialectDomainElement> parameterElements) {
    return parameterElements.stream()
        .map(this::parseParameter)
        .collect(toList());
  }

  private ParameterDescriptor parseParameter(DialectDomainElement parameterElement) {
    return new ParameterDescriptor(parseFriendlyName(parameterElement),
                                   getExternalName(parameterElement),
                                   getDescription(parameterElement),
                                   getIgnored(parameterElement),
                                   valueResolverReferenceParser.parseValueResolverReference(parameterElement));
  }

  private boolean getIgnored(DialectDomainElement parameterElement) {
    return parseIgnore(parameterElement);
  }

  private String getExternalName(DialectDomainElement parameterElement) {
    return parseApiContractParamName(parameterElement);
  }

  private String getDescription(DialectDomainElement parameterElement) {
    return parseCoreDescription(parameterElement);
  }
}
