/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.AMFWrapper;

import java.io.File;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseCoreDescription;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseCoreName;

/*
 This class knows how to parse an AML connector descriptor file to generate the corresponding ConnectorDescriptor model.
 */
public final class DescriptorParser {

  private static final DescriptorBaseUriParser baseUriParser = new DescriptorBaseUriParser();
  private static final DescriptorEndpointParser endpointParser = new DescriptorEndpointParser();
  private static final DescriptorApiSpecParser apiSpecParser = new DescriptorApiSpecParser();
  private static final DescriptorMavenGavParser mavenGavParser = new DescriptorMavenGavParser();
  private static final DescriptorEncodesParser encodesParser = new DescriptorEncodesParser();
  private static final DescriptorSecurityParser securityParser = new DescriptorSecurityParser();
  private static final DescriptorTestConnectionParser testConnectionParser = new DescriptorTestConnectionParser();
  private static final DescriptorTriggerParser triggerParser = new DescriptorTriggerParser();
  private static final DescriptorPaginationParser paginationParser = new DescriptorPaginationParser();
  private static final DescriptorValueResolverParser valueResolverParser = new DescriptorValueResolverParser();

  public ConnectorDescriptor parseConnectorDescriptor(File connectorDescriptor)
      throws ModelGenerationException {

    final DialectDomainElement encodes = AMFWrapper.parseConnectorDescriptor(connectorDescriptor).encodes();

    return new ConnectorDescriptor(
                                   apiSpecParser.parseApiSpec(encodes),
                                   parseCoreName(encodes),
                                   parseCoreDescription(encodes),
                                   mavenGavParser.parseMavenGav(mavenGavParser.parseConnectorGavElement(encodes)),
                                   baseUriParser.parseBaseUri(encodes),
                                   endpointParser.parseEndpoints(encodes, connectorDescriptor.toPath()),
                                   paginationParser.parsePaginationsDescription(encodes),
                                   securityParser.parseSecurityScheme(encodes),
                                   encodesParser.parseConnectorCategory(encodes),
                                   encodesParser.parseJavaPackage(encodes),
                                   encodesParser.parseExtensionXml(encodes),
                                   encodesParser.parseSkipOutputTypeValidation(encodes),
                                   encodesParser.parseDefaultInputMediaType(encodes),
                                   encodesParser.parseDefaultOutputMediaType(encodes),
                                   encodesParser.parseQueryParamArrayFormat(encodes),
                                   testConnectionParser.parseTestConnection(encodes),
                                   triggerParser.parseTriggers(encodes),
                                   valueResolverParser.parseValueResolvers(encodes));
  }
}
