/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.*;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorPartParser {

  private static final String REST_SDK_FRIENDLY_NAME = "http://a.ml/vocabularies/rest-sdk#friendlyName";
  private static final String REST_SDK_INPUT_TYPE = "http://a.ml/vocabularies/rest-sdk#inputType";
  private static final String REST_SDK_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/rest-sdk#inputMediaType";
  private static final String REST_SDK_FILE_PART = "http://a.ml/vocabularies/rest-sdk#filePart";


  public List<PartDescriptor> parseParts(List<DialectDomainElement> parameterElements, Path descriptorFilePath)
      throws ModelGenerationException {

    List<PartDescriptor> parts = new ArrayList<>();
    for (DialectDomainElement p : parameterElements) {
      parts.add(parsePart(p, descriptorFilePath));
    }

    return parts;
  }

  private PartDescriptor parsePart(DialectDomainElement partElement, Path descriptorFilePath)
      throws ModelGenerationException {
    return new PartDescriptor(getPartName(partElement),
                              getFriendlyName(partElement),
                              getDescription(partElement),
                              getInputTypeSchema(partElement, descriptorFilePath),
                              getContentType(partElement),
                              getFilePart(partElement));
  }

  private String getPartName(DialectDomainElement partElement) {
    return parseApiContractParamName(partElement);
  }

  private String getFriendlyName(DialectDomainElement partElement) {
    return parseSingleStringProperty(partElement, REST_SDK_FRIENDLY_NAME);
  }

  private String getDescription(DialectDomainElement partElement) {
    return parseCoreDescription(partElement);
  }

  private String getInputTypeSchema(DialectDomainElement partElement, Path descriptorDirectory)
      throws ModelGenerationException {
    String inputSchemaPathString = parseSingleStringProperty(partElement, REST_SDK_INPUT_TYPE);
    return getSchemaContent(descriptorDirectory, inputSchemaPathString);
  }

  private String getContentType(DialectDomainElement partElement) {
    return parseSingleStringProperty(partElement, REST_SDK_INPUT_MEDIA_TYPE);
  }

  private boolean getFilePart(DialectDomainElement partElement) {
    return parseSingleBooleanProperty(partElement, REST_SDK_FILE_PART);
  }
}
