/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import static java.util.stream.Collectors.toList;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;

import java.util.List;

import javax.validation.constraints.NotNull;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorTestConnectionResponseValidationParser {

  private static final String RESPONSE_VALIDATION = "http://a.ml/vocabularies/rest-sdk#testConnectionResponseValidation";

  private static final String VALIDATION_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#testConnectionValidationExpression";
  private static final String ERROR_TEMPLATE_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#testConnectionErrorTemplate";

  private static final DescriptorExpressionParser descriptorExpressionParser = new DescriptorExpressionParser();

  public List<TestConnectionResponseValidationDescriptor> parseResponseValidations(DialectDomainElement testConnectionElement) {
    return getResponseValidationElements(testConnectionElement).stream()
        .map(this::parseResponseValidation)
        .collect(toList());
  }

  private TestConnectionResponseValidationDescriptor parseResponseValidation(DialectDomainElement responseValidationElement) {
    if (responseValidationElement == null) {
      return null;
    }

    return new TestConnectionResponseValidationDescriptor(
                                                          descriptorExpressionParser
                                                              .parseExpression(getValidationExpressionElement(responseValidationElement)),
                                                          descriptorExpressionParser
                                                              .parseExpression(getErrorExpressionElement(responseValidationElement)));
  }

  private List<DialectDomainElement> getResponseValidationElements(@NotNull DialectDomainElement testConnectionElement) {
    return testConnectionElement.getObjectPropertyUri(RESPONSE_VALIDATION);
  }

  private DialectDomainElement getValidationExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
    return getSingleObjectProperty(responseValidationElement, VALIDATION_EXPRESSION);
  }

  private DialectDomainElement getErrorExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
    return getSingleObjectProperty(responseValidationElement, ERROR_TEMPLATE_EXPRESSION);
  }
}
