/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerWatermarkDescriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.getSingleObjectProperty;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils.parseSingleStringProperty;

public class DescriptorTriggerWatermarkParser {

  private static final String AML_REST_SDK_TRIGGER_WATERMARK_EXTRACTION =
      "http://a.ml/vocabularies/rest-sdk#triggerWatermarkExtraction";
  private static final String AML_REST_SDK_TRIGGER_WATERMARK_TYPE =
      "http://a.ml/vocabularies/rest-sdk#triggerWatermarkType";

  private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

  public TriggerWatermarkDescriptor parseWatermark(DialectDomainElement triggerWatermarkDescriptor) {
    if (triggerWatermarkDescriptor == null) {
      return null;
    }

    return new TriggerWatermarkDescriptor(
                                          parseExtractionExpression(triggerWatermarkDescriptor),
                                          parseDataType(triggerWatermarkDescriptor));
  }

  private String parseExtractionExpression(DialectDomainElement triggerWatermarkDescriptor) {
    DialectDomainElement singleObjectProperty =
        getSingleObjectProperty(triggerWatermarkDescriptor, AML_REST_SDK_TRIGGER_WATERMARK_EXTRACTION);
    return expressionParser.parseExpression(singleObjectProperty).getExpression();
  }

  private DataTypeDescriptor parseDataType(DialectDomainElement triggerWatermarkDescriptor) {
    return DataTypeDescriptor
        .forName(parseSingleStringProperty(triggerWatermarkDescriptor, AML_REST_SDK_TRIGGER_WATERMARK_TYPE));
  }
}
