/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;

import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;

import java.nio.file.Path;

public class SdkOperation extends AbstractSdkOperation {

  public SdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation,
                      RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  public FieldSpec generateExpressionLanguageField() {
    return null;
  }

  public ParameterSpec generateInitialPagingParameter() {
    return null;
  }

  public TypeName generateMethodReturn() {
    return null;
  }

  public CodeBlock generateOperationMethodBody() {
    return generateOperationMethodBody("callback");
  }

  protected CodeBlock generateOperationMethodBody(String callbackParameterName) {
    CodeBlock.Builder methodBody = super.generateCommonOperationMethodBody();

    if (!isVoidOperation() && (outputMetadataResolver != null || operationMethodRequiresBody())) {
      methodBody
          .addStatement("doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, "
              + callbackParameterName + ")");
    } else {
      methodBody
          .addStatement("doVoidRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, "
              + callbackParameterName + ")");
    }

    return methodBody.build();
  }
}
