/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIPrimitiveTypeModel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;

import java.util.HashMap;
import java.util.Map;

public class AMFPrimitiveTypeModel extends APIPrimitiveTypeModel {

  public AMFPrimitiveTypeModel(Shape shape) {
    this.primitiveType = getPrimitiveType(shape);
  }

  public AMFPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType primitiveTypeDefinition) {
    this.primitiveType = primitiveTypeDefinition;
  }

  private static final Map<String, PrimitiveTypeDefinition.PrimitiveType> scalarTypeMappings = new HashMap<>();
  static {
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", PrimitiveTypeDefinition.PrimitiveType.BOOLEAN);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", PrimitiveTypeDefinition.PrimitiveType.NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", PrimitiveTypeDefinition.PrimitiveType.INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", PrimitiveTypeDefinition.PrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", PrimitiveTypeDefinition.PrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", PrimitiveTypeDefinition.PrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", PrimitiveTypeDefinition.PrimitiveType.STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", PrimitiveTypeDefinition.PrimitiveType.DATE_TIME);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY);
  }

  private PrimitiveTypeDefinition.PrimitiveType getPrimitiveType(Shape shape) {

    if (shape instanceof ScalarShape) {
      return scalarTypeMappings.get(((ScalarShape) shape).dataType().value());
    }

    else if (shape instanceof FileShape) {
      return PrimitiveTypeDefinition.PrimitiveType.FILE;
    }

    //Reaching this line would mean that a new type is supported in AMF but we have not implemented it in Rest SDK yet
    throw new IllegalArgumentException("Type declaration is not a primitive type.");
  }

}
