/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security;

import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.OAuth2Flow;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.security.OAS2Oauth2Flows;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.security.RAMLOauth2Flows;

public class AMFOauth2FlowsNaming {

  private AMFOauth2FlowsNaming() {}

  public static boolean isAuthorizationCode(OAuth2Settings oAuth2Settings, OAuth2Flow oAuth2Flow) {
    if (oAuth2Settings.authorizationGrants().stream()
        .anyMatch(x -> RAMLOauth2Flows.AUTHORIZATION_CODE.equalsIgnoreCase(x.value()))) {
      return true;
    }

    return OAS2Oauth2Flows.ACCESS_CODE.equalsIgnoreCase(oAuth2Flow.flow().value());
  }

  public static boolean isClientCredentials(OAuth2Settings oAuth2Settings, OAuth2Flow oAuth2Flow) {
    if (oAuth2Settings.authorizationGrants().stream()
        .anyMatch(x -> RAMLOauth2Flows.CLIENT_CREDENTIALS.equalsIgnoreCase(x.value()))) {
      return true;
    }

    return OAS2Oauth2Flows.APPLICATION.equalsIgnoreCase(oAuth2Flow.flow().value());
  }
}
