/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.OperationNamingUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConnectorOperation {
    private final String internalName;
    private final String displayName;
    private final String description;
    private final String alternativeBaseUri;
    private final String path;
    private final HTTPMethod httpMethod;
    private final String pagination;
    private final List<Parameter> uriParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headers;
    private final TypeDefinition inputMetadata;
    private final TypeDefinition outputMetadata;
    private final Boolean skipOutputTypeValidation;
    private final Boolean voidOperation;
    private final QueryParamArrayFormat queryParamArrayFormat;
    private final List<ConnectorSecurityScheme> securitySchemes;

    public ConnectorOperation(String displayName, String description, String path, HTTPMethod httpMethod, List<Parameter> uriParameters, List<Parameter> queryParameters, List<Parameter> headers, TypeDefinition inputMetadata, TypeDefinition outputMetadata, List<ConnectorSecurityScheme> securitySchemes, String alternativeBaseUri, String pagination, Boolean skipOutputTypeValidation, Boolean voidOperation, QueryParamArrayFormat queryParamArrayFormat) {
        this.internalName = XmlUtils.getXmlName(OperationNamingUtils.buildCanonicalOperationName(httpMethod, path));
        this.displayName = displayName;
        this.description = description;
        this.path = path;
        this.httpMethod = httpMethod;
        this.uriParameters = uriParameters;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.inputMetadata = inputMetadata;
        this.outputMetadata = outputMetadata;
        this.securitySchemes = securitySchemes;
        this.alternativeBaseUri = alternativeBaseUri;
        this.pagination = pagination;
        this.skipOutputTypeValidation = skipOutputTypeValidation;
        this.voidOperation = voidOperation;
        this.queryParamArrayFormat = queryParamArrayFormat;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.httpMethod.toString().toLowerCase();
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }

    public List<ConnectorSecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAlternativeBaseUri() {
        return this.alternativeBaseUri;
    }

    public String getPagination() {
        return this.pagination;
    }

    public boolean hasPagination() {
        return StringUtils.isNotBlank((CharSequence)this.pagination);
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public Boolean getVoidOperation() {
        return this.voidOperation;
    }

    public QueryParamArrayFormat getQueryParamArrayFormat() {
        return this.queryParamArrayFormat;
    }
}

