/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorPackage;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorOperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorValueResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.InPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.OutPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.ResponseValueExtraction;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.InPaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OutPaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.AMFWrapper;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConnectorModelBuilder {
    private static final List<Protocol> DEFAULT_PROTOCOLS = new ArrayList<Protocol>();
    private final ConnectorOperationBuilder connectorOperationBuilder = new ConnectorOperationBuilder(new TypeSchemaPool());
    private final ConnectorTriggerBuilder connectorTriggerBuilder = new ConnectorTriggerBuilder();
    private final ConnectorValueResolverBuilder connectorValueResolverBuilder = new ConnectorValueResolverBuilder();

    public ConnectorModel buildConnectorModel(APIModel apiModel, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        AMFWrapper.initialize();
        List<Protocol> protocols = ConnectorModelBuilder.buildProtocols(apiModel);
        List<ConnectorOperation> operations = this.connectorOperationBuilder.buildOperations(apiModel, connectorDescriptor);
        return new ConnectorModel(ConnectorModelBuilder.buildConnectorName(connectorDescriptor), connectorDescriptor.getConnectorDescription(), ConnectorModelBuilder.buildMavenGroup(connectorDescriptor), ConnectorModelBuilder.buildMavenArtifactId(connectorDescriptor), ConnectorModelBuilder.buildMavenVersion(connectorDescriptor), ConnectorModelBuilder.buildBasePackage(connectorDescriptor), ConnectorModelBuilder.buildConnectorCategory(connectorDescriptor), ConnectorModelBuilder.buildBaseUri(connectorDescriptor, apiModel, protocols), protocols, operations, ConnectorModelBuilder.buildPaginations(connectorDescriptor), ConnectorModelBuilder.buildExtensionXml(connectorDescriptor), ConnectorModelBuilder.buildSkipOutputTypeValidation(connectorDescriptor), this.buildQueryParamArrayFormat(connectorDescriptor), this.connectorTriggerBuilder.buildTriggers(connectorDescriptor, operations), this.connectorValueResolverBuilder.buildValueResolvers(connectorDescriptor));
    }

    protected QueryParamArrayFormat buildQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return QueryParamArrayFormat.MULTIMAP;
    }

    private static String buildConnectorName(ConnectorDescriptor connectorDescriptor) {
        String connectorName = connectorDescriptor.getConnectorName().trim();
        if (connectorName.toLowerCase().endsWith("api")) {
            connectorName = connectorName.substring(0, connectorName.lastIndexOf("api"));
        }
        if (connectorName.toLowerCase().endsWith("connector")) {
            return connectorName;
        }
        return connectorName + " Connector";
    }

    private static Boolean buildSkipOutputTypeValidation(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getSkipOutputTypeValidation();
    }

    private static String buildExtensionXml(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getExtensionXml())) {
            return connectorDescriptor.getExtensionXml();
        }
        return XmlUtils.getXmlName(connectorDescriptor.getConnectorName());
    }

    private static String buildBasePackage(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getBaseJavaPackage())) {
            return connectorDescriptor.getBaseJavaPackage();
        }
        return ConnectorPackage.buildBasePackage(connectorDescriptor.getConnectorName());
    }

    private static List<Protocol> buildProtocols(APIModel apiModel) {
        return apiModel.getProtocols().isEmpty() ? DEFAULT_PROTOCOLS : apiModel.getProtocols();
    }

    private static String buildMavenGroup(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenGroupUnwantedCharacters(connectorDescriptor.getConnectorGav().getGroupId());
    }

    private static String buildMavenArtifactId(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenArtifactUnwantedCharacters(connectorDescriptor.getConnectorGav().getArtifactId());
    }

    private static String buildMavenVersion(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenVersionUnwantedCharacters(connectorDescriptor.getConnectorGav().getVersion());
    }

    private static ConnectorCategory buildConnectorCategory(ConnectorDescriptor connectorDescriptor) {
        return ConnectorCategory.fromString(connectorDescriptor.getConnectorCategory());
    }

    private static BaseUri buildBaseUri(ConnectorDescriptor connectorDescriptor, APIModel apiModel, List<Protocol> supportedProtocols) {
        if (connectorDescriptor.getBaseUri() == null) {
            return apiModel.getBaseUri();
        }
        BaseUri generatedUri = new BaseUri(connectorDescriptor.getBaseUri().getValue(), BaseUri.Type.valueOfName(connectorDescriptor.getBaseUri().getType()), apiModel.getBaseUri().getApiVersion(), supportedProtocols);
        connectorDescriptor.getBaseUri().getMapping().forEach(x -> generatedUri.addMultipleBaseUri(x.getName(), x.getValue(), x.isDefault()));
        return generatedUri;
    }

    private static Map<String, Pagination> buildPaginations(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Pagination> paginations = new ArrayList<Pagination>(connectorDescriptor.getPaginations().size());
        for (PaginationDeclarationDescriptor paginationDescriptor : connectorDescriptor.getPaginations()) {
            paginations.add(new Pagination(paginationDescriptor.getName(), paginationDescriptor.getType(), ConnectorModelBuilder.getPagingDescriptorParameters(paginationDescriptor.getParameters())));
        }
        HashMap<String, Pagination> paginationMap = new HashMap<String, Pagination>();
        paginations.forEach(paging -> paginationMap.put(paging.getName(), (Pagination)paging));
        return paginationMap;
    }

    private static List<PaginationParameter> getPagingDescriptorParameters(List<PaginationParameterDescriptor> pagingParameters) {
        ArrayList<PaginationParameter> parameters = new ArrayList<PaginationParameter>(pagingParameters.size());
        for (PaginationParameterDescriptor parameterDescriptor : pagingParameters) {
            parameters.add(ConnectorModelBuilder.getPaginationParameter(parameterDescriptor));
        }
        return parameters;
    }

    private static PaginationParameter getPaginationParameter(PaginationParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor instanceof InPaginationParameterDescriptor) {
            ResponseValueExtraction valueExtraction = new ResponseValueExtraction(((InPaginationParameterDescriptor)parameterDescriptor).getValueExtraction().getLanguage(), ((InPaginationParameterDescriptor)parameterDescriptor).getValueExtraction().getExpression());
            return new InPaginationParameter(parameterDescriptor.getName(), valueExtraction);
        }
        return new OutPaginationParameter(parameterDescriptor.getName(), ((OutPaginationParameterDescriptor)parameterDescriptor).getValue());
    }

    static {
        DEFAULT_PROTOCOLS.add(Protocol.HTTP);
        DEFAULT_PROTOCOLS.add(Protocol.HTTPS);
    }
}

