/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type;

import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ObjectTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.UnionTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.util.HashCodeUtil;
import java.util.List;
import javax.ws.rs.core.MediaType;

public abstract class TypeDefinition {
    protected final MediaType mediaType;
    protected final String example;
    protected final List<String> enumValues;
    protected final TypeSchema typeSchema;
    protected final String displayName;
    protected final String description;

    TypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema, String displayName, String description) {
        this.mediaType = mediaType;
        this.example = example;
        this.enumValues = enumValues;
        this.typeSchema = typeSchema;
        this.displayName = displayName;
        this.description = description;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public TypeSchema getTypeSchema() {
        return this.typeSchema;
    }

    public boolean isEnum() {
        return this.enumValues != null && !this.enumValues.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static TypeDefinition simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType type) {
        return new PrimitiveTypeDefinition(MediaType.TEXT_PLAIN_TYPE, null, null, null, type, null, null);
    }

    public static TypeDefinition simpleStringType() {
        return TypeDefinition.simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType.STRING);
    }

    public int hashCode() {
        String mediaTypeString = this.mediaType != null ? this.mediaType.toString() : null;
        return HashCodeUtil.generateHashCode(mediaTypeString, this.example, this.enumValues, this.typeSchema);
    }

    public static Builder builder(MediaType mediaType, TypeSchema typeSchema, List<String> enumValues, String example) throws ModelGenerationException {
        if (mediaType == null) {
            throw new ModelGenerationException("Media Type can not be empty");
        }
        return new Builder(mediaType, typeSchema, enumValues, example);
    }

    public static class Builder {
        private final MediaType mediaType;
        private final TypeSchema typeSchema;
        private final List<String> enumValues;
        private final String example;
        private String displayName;
        private String description;

        Builder(MediaType mediaType, TypeSchema typeSchema, List<String> enumValues, String example) {
            this.mediaType = mediaType;
            this.typeSchema = typeSchema;
            this.enumValues = enumValues;
            this.example = example;
        }

        public ArrayTypeDefinition buildArrayType(TypeDefinition innerType) {
            return new ArrayTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, innerType, this.displayName, this.description);
        }

        public MultipartTypeDefinition buildMultipartTypeDefinition(List<PartParameter> parts) {
            return new MultipartTypeDefinition(this.example, this.enumValues, this.typeSchema, parts, this.displayName, this.description);
        }

        public ObjectTypeDefinition buildObjectTypeDefinition() {
            return new ObjectTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, this.displayName, this.description);
        }

        public PrimitiveTypeDefinition buildPrimitiveTypeDefinition(PrimitiveTypeDefinition.PrimitiveType primitiveType) {
            return new PrimitiveTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, primitiveType, this.displayName, this.description);
        }

        public UnionTypeDefinition buildUnionTypeDefinition(List<TypeDefinition> unionTypes) {
            return new UnionTypeDefinition(this.mediaType, this.example, this.enumValues, this.typeSchema, unionTypes, this.displayName, this.description);
        }

        public EmptyTypeDefinition buildEmptyTypeDefinition() {
            return new EmptyTypeDefinition(this.mediaType, this.example, this.enumValues, this.displayName, this.description);
        }

        public void withDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void withDescription(String description) {
            this.description = description;
        }
    }
}

