/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.model;

import org.apache.commons.lang3.StringUtils;

public enum HttpMethodDescriptor {
    GET("get"),
    POST("post"),
    PUT("put"),
    PATCH("patch"),
    DELETE("delete"),
    HEAD("head"),
    OPTIONS("options");

    private final String name;

    private HttpMethodDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static HttpMethodDescriptor forName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.equalsIgnoreCase(GET.getName())) {
            return GET;
        }
        if (name.equalsIgnoreCase(POST.getName())) {
            return POST;
        }
        if (name.equalsIgnoreCase(PUT.getName())) {
            return PUT;
        }
        if (name.equalsIgnoreCase(PATCH.getName())) {
            return PATCH;
        }
        if (name.equalsIgnoreCase(DELETE.getName())) {
            return DELETE;
        }
        if (name.equalsIgnoreCase(HEAD.getName())) {
            return HEAD;
        }
        if (name.equalsIgnoreCase(OPTIONS.getName())) {
            return OPTIONS;
        }
        throw new IllegalArgumentException("HTTP Method not supported: " + name);
    }
}

