/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APISpecDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APIUrlDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorMavenGavParser;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DescriptorApiSpecParser {
    private static final String REST_SDK_API_SPEC = "http://a.ml/vocabularies/rest-sdk#webAPISpecAsset";
    private static final String REST_SDK_API_SPEC_URL = "http://anypoint.com/vocabs/digital-repository#webAPISpecAssetURL";
    private static final DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();

    public APISpecDescriptor parseApiSpec(DialectDomainElement encodes) {
        DialectDomainElement apiSpecElement = this.parseApiSpecElement(encodes);
        if (apiSpecElement == null) {
            return null;
        }
        String url = this.parseUrl(apiSpecElement);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return new APIUrlDescriptor(url);
        }
        return descriptorMavenGavParser.parseMavenGav(apiSpecElement);
    }

    public DialectDomainElement parseApiSpecElement(DialectDomainElement encodes) {
        List apiSpecElements = encodes.getObjectPropertyUri(REST_SDK_API_SPEC);
        return apiSpecElements.isEmpty() ? null : (DialectDomainElement)apiSpecElements.get(0);
    }

    public String parseUrl(DialectDomainElement apiSpecElement) {
        List groupIds = apiSpecElement.getScalarByPropertyUri(REST_SDK_API_SPEC_URL);
        return groupIds.isEmpty() ? null : groupIds.get(0).toString();
    }
}

