/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;

public class DescriptorMavenGavParser {
    private static final String REST_SDK_CONNECTOR_GAV = "http://a.ml/vocabularies/rest-sdk#connectorGav";
    private static final String ANYPOINT_TENANT_ID = "http://anypoint.com/vocabs/anypoint#tenantId";
    private static final String DIGITAL_REPOSITORY_ARTIFACT_ID = "http://anypoint.com/vocabs/digital-repository#assetId";
    private static final String SCHEMA_ORG_VERSION = "http://anypoint.com/vocabs/schema-org#version";

    public MavenGavDescriptor parseMavenGav(DialectDomainElement mavenGavElement) {
        if (mavenGavElement == null) {
            return null;
        }
        return new MavenGavDescriptor(this.parseGroupId(mavenGavElement), this.parseArtifactId(mavenGavElement), this.parseVersion(mavenGavElement));
    }

    public DialectDomainElement parseConnectorGavElement(DialectDomainElement encodes) {
        return DescriptorParserUtils.getSingleObjectProperty(encodes, REST_SDK_CONNECTOR_GAV);
    }

    private String parseGroupId(DialectDomainElement mavenGavElement) {
        return DescriptorParserUtils.parseSingleStringProperty(mavenGavElement, ANYPOINT_TENANT_ID);
    }

    private String parseArtifactId(DialectDomainElement mavenGavElement) {
        return DescriptorParserUtils.parseSingleStringProperty(mavenGavElement, DIGITAL_REPOSITORY_ARTIFACT_ID);
    }

    private String parseVersion(DialectDomainElement mavenGavElement) {
        return DescriptorParserUtils.parseSingleStringProperty(mavenGavElement, SCHEMA_ORG_VERSION);
    }
}

