/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorEncodesParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorRequestParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class DescriptorOperationParser {
    private static final String API_CONTRACT_SUPPORTED_OPERATION = "http://a.ml/vocabularies.rest.sdk/apiContract#supportedOperation";
    private static final String REST_SDK_OPERATION_NAME = "http://a.ml/vocabularies/rest-sdk#operationName";
    private static final String REST_SDK_OPERATION_DESCRIPTION = "http://a.ml/vocabularies/rest-sdk#operationDescription";
    private static final String REST_SDK_DEFAULT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/rest-sdk#inputMediaType";
    private static final String REST_SDK_DEFAULT_OUTPUT_MEDIA_TYPE = "http://a.ml/vocabularies/rest-sdk#outputMediaType";
    private static final String REST_SDK_INPUT_TYPE = "http://a.ml/vocabularies/rest-sdk#inputType";
    private static final String REST_SDK_OUTPUT_TYPE = "http://a.ml/vocabularies/rest-sdk#outputType";
    private static final String REST_SDK_PAGINATION = "http://a.ml/vocabularies/rest-sdk#paginationReference";
    private static final String REST_SDK_VOID_OPERATION = "http://a.ml/vocabularies/rest-sdk#voidOperation";
    private static final String QUERY_PARAM_ARRAY_FORMAT = "http://a.ml/vocabularies/rest-sdk#queryParameterArrayFormat";
    private final DescriptorRequestParser descriptorRequestParser = new DescriptorRequestParser();
    private final DescriptorEncodesParser descriptorEncodesParser = new DescriptorEncodesParser();

    public List<OperationDescriptor> parseOperations(DialectDomainElement endpointElement, Path descriptorFilePath) throws ModelGenerationException {
        ArrayList<OperationDescriptor> operationDescriptors = new ArrayList<OperationDescriptor>();
        for (DialectDomainElement x : this.getSupportedOperations(endpointElement)) {
            operationDescriptors.add(this.parseOperation(x, descriptorFilePath));
        }
        return operationDescriptors;
    }

    private OperationDescriptor parseOperation(DialectDomainElement operationElement, Path descriptorFilePath) throws ModelGenerationException {
        Path descriptorDirectory = descriptorFilePath.getParent();
        return new OperationDescriptor(DescriptorParserUtils.parseApiContractMethod(operationElement), this.getName(operationElement), this.getDescription(operationElement), this.getDefaultInputMediaType(operationElement), this.getDefaultOutputMediaType(operationElement), this.descriptorRequestParser.parseRequest(operationElement, descriptorDirectory), DescriptorParserUtils.parseNullableIgnore(operationElement), DescriptorParserUtils.parseAlternativeBaseUri(operationElement), this.getPagination(operationElement), this.descriptorEncodesParser.parseSkipOutputTypeValidation(operationElement), this.parseVoidOperation(operationElement), this.getInputTypeSchema(operationElement, descriptorDirectory), this.getOutputTypeSchema(operationElement, descriptorDirectory), this.getQueryParamArrayFormat(operationElement));
    }

    private List<DialectDomainElement> getSupportedOperations(DialectDomainElement endpointElement) {
        return endpointElement.getObjectPropertyUri(API_CONTRACT_SUPPORTED_OPERATION);
    }

    private Boolean parseVoidOperation(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleBooleanOrNullProperty(operationElement, REST_SDK_VOID_OPERATION);
    }

    private String getDescription(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_OPERATION_DESCRIPTION);
    }

    private String getName(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_OPERATION_NAME);
    }

    private String getDefaultInputMediaType(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_DEFAULT_INPUT_MEDIA_TYPE);
    }

    private String getInputTypeSchema(DialectDomainElement operationElement, Path descriptorDirectory) throws ModelGenerationException {
        String inputSchemaPath = DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_INPUT_TYPE);
        return DescriptorParserUtils.getSchemaContent(descriptorDirectory, inputSchemaPath);
    }

    private String getOutputTypeSchema(DialectDomainElement operationElement, Path descriptorDirectory) throws ModelGenerationException {
        String outputSchemaPath = DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_OUTPUT_TYPE);
        return DescriptorParserUtils.getSchemaContent(descriptorDirectory, outputSchemaPath);
    }

    private String getDefaultOutputMediaType(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_DEFAULT_OUTPUT_MEDIA_TYPE);
    }

    private String getPagination(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, REST_SDK_PAGINATION);
    }

    private String getQueryParamArrayFormat(DialectDomainElement operationElement) {
        return DescriptorParserUtils.parseSingleStringProperty(operationElement, QUERY_PARAM_ARRAY_FORMAT);
    }
}

