/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.InPaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OutPaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorExpressionParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;

public class DescriptorPaginationParser {
    private static final String AML_REST_SDK_PAGINATION_DECLARATIONS = "http://a.ml/vocabularies/rest-sdk#paginationDeclarations";
    private static final String AML_REST_SDK_PAGINATION_DECLARATION = "http://a.ml/vocabularies.rest.sdk/core#name";
    private static final String AML_REST_SDK_PAGINATION_TYPE = "http://a.ml/vocabularies/rest-sdk#paginationType";
    private static final String AML_REST_SDK_PAGINATION_PARAMETERS = "http://a.ml/vocabularies/rest-sdk#paginationParameters";
    private static final String AML_REST_SDK_PAGINATION_OFFSET_PARAM_NAME = "http://a.ml/vocabularies/rest-sdk#offsetParamName";
    private static final String AML_REST_SDK_PAGINATION_INITIAL_OFFSET = "http://a.ml/vocabularies/rest-sdk#initialOffset";
    private static final String AML_REST_SDK_PAGINATION_NEXT_TOKEN_PARAM_NAME = "http://a.ml/vocabularies/rest-sdk#nextTokenParamName";
    private static final String AML_REST_SDK_PAGINATION_NEXT_TOKEN_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#nextTokenExpression";
    private static final String AML_REST_SDK_PAGINATION_PAGE_NUMBER_PARAM_NAME = "http://a.ml/vocabularies/rest-sdk#pageNumberParamName";
    private static final String AML_REST_SDK_PAGINATION_INITIAL_PAGE_NUMBER = "http://a.ml/vocabularies/rest-sdk#initialPageNumber";
    private static final String AML_REST_SDK_PAGINATION_PAGING_RESPONSE_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#pagingResponseExpression";
    private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

    public List<PaginationDeclarationDescriptor> parsePaginationsDescription(DialectDomainElement encodes) {
        List paginationsDescriptor = encodes.getObjectPropertyUri(AML_REST_SDK_PAGINATION_DECLARATIONS);
        return paginationsDescriptor.isEmpty() ? Collections.emptyList() : this.getPagingMethods(paginationsDescriptor);
    }

    private List<PaginationDeclarationDescriptor> getPagingMethods(List<DialectDomainElement> paginationsDescriptor) {
        ArrayList<PaginationDeclarationDescriptor> paginationDeclarationDescriptors = new ArrayList<PaginationDeclarationDescriptor>(paginationsDescriptor.size());
        for (DialectDomainElement endpointsElement : paginationsDescriptor) {
            String pagingStrategyName = this.parsePagingStrategyName(endpointsElement);
            String pagingType = this.parsePagingType(endpointsElement);
            List parameters = endpointsElement.getObjectPropertyUri(AML_REST_SDK_PAGINATION_PARAMETERS);
            ArrayList<PaginationParameterDescriptor> paginationParameterDescriptors = new ArrayList<PaginationParameterDescriptor>(parameters.size());
            if (!parameters.isEmpty()) {
                InPaginationParameterDescriptor pagingResponseExpression;
                OutPaginationParameterDescriptor initialPageNumber;
                OutPaginationParameterDescriptor pageNumberParamName;
                InPaginationParameterDescriptor nextTokenExpression;
                OutPaginationParameterDescriptor nextTokenParamName;
                OutPaginationParameterDescriptor initialOffsetDescriptor;
                DialectDomainElement pagingParameterItem = (DialectDomainElement)parameters.get(0);
                OutPaginationParameterDescriptor offsetParamNameDescriptor = this.parseOffsetParamName(pagingParameterItem);
                if (offsetParamNameDescriptor != null) {
                    paginationParameterDescriptors.add(offsetParamNameDescriptor);
                }
                if ((initialOffsetDescriptor = this.parseInitialOffset(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(initialOffsetDescriptor);
                }
                if ((nextTokenParamName = this.parseNextTokenParamName(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(nextTokenParamName);
                }
                if ((nextTokenExpression = this.parseNextTokenExpression(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(nextTokenExpression);
                }
                if ((pageNumberParamName = this.parsePageNumberParamName(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(pageNumberParamName);
                }
                if ((initialPageNumber = this.parseInitialPageNumber(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(initialPageNumber);
                }
                if ((pagingResponseExpression = this.parsePagingResponseExpression(pagingParameterItem)) != null) {
                    paginationParameterDescriptors.add(pagingResponseExpression);
                }
            }
            paginationDeclarationDescriptors.add(new PaginationDeclarationDescriptor(pagingStrategyName, pagingType, paginationParameterDescriptors));
        }
        return paginationDeclarationDescriptors;
    }

    private OutPaginationParameterDescriptor parseOffsetParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List offsetParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_OFFSET_PARAM_NAME);
        return offsetParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("offsetParamName", offsetParamName.get(0).toString());
    }

    private OutPaginationParameterDescriptor parseInitialOffset(@NotNull DialectDomainElement pagingParameterItem) {
        List initialOffset = pagingParameterItem.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_INITIAL_OFFSET);
        return initialOffset.isEmpty() ? null : new OutPaginationParameterDescriptor("initialOffset", initialOffset.get(0).toString());
    }

    private OutPaginationParameterDescriptor parseNextTokenParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List nextTokenParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_NEXT_TOKEN_PARAM_NAME);
        return nextTokenParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("nextTokenParamName", nextTokenParamName.get(0).toString());
    }

    private OutPaginationParameterDescriptor parsePageNumberParamName(@NotNull DialectDomainElement pagingParameterItem) {
        List pageNumberParamName = pagingParameterItem.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_PAGE_NUMBER_PARAM_NAME);
        return pageNumberParamName.isEmpty() ? null : new OutPaginationParameterDescriptor("pageNumberParamName", pageNumberParamName.get(0).toString());
    }

    private OutPaginationParameterDescriptor parseInitialPageNumber(@NotNull DialectDomainElement pagingParameterItem) {
        List initialPageNumber = pagingParameterItem.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_INITIAL_PAGE_NUMBER);
        return initialPageNumber.isEmpty() ? null : new OutPaginationParameterDescriptor("initialPageNumber", initialPageNumber.get(0).toString());
    }

    private InPaginationParameterDescriptor parseNextTokenExpression(@NotNull DialectDomainElement pagingParameterItem) {
        List nextTokenExpression = pagingParameterItem.getObjectPropertyUri(AML_REST_SDK_PAGINATION_NEXT_TOKEN_EXPRESSION);
        ExpressionDescriptor expressionDescriptor = this.parseResponseValueExtractionDescriptor(nextTokenExpression);
        return expressionDescriptor == null ? null : new InPaginationParameterDescriptor("nextTokenExpression", expressionDescriptor);
    }

    private InPaginationParameterDescriptor parsePagingResponseExpression(@NotNull DialectDomainElement pagingParameterItem) {
        List pagingResponseExpression = pagingParameterItem.getObjectPropertyUri(AML_REST_SDK_PAGINATION_PAGING_RESPONSE_EXPRESSION);
        ExpressionDescriptor expressionDescriptor = this.parseResponseValueExtractionDescriptor(pagingResponseExpression);
        return expressionDescriptor == null ? null : new InPaginationParameterDescriptor("pagingResponseExpression", expressionDescriptor);
    }

    private String parsePagingStrategyName(@NotNull DialectDomainElement endpointsElement) {
        List pagingStrategyNames = endpointsElement.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_DECLARATION);
        return pagingStrategyNames.isEmpty() ? null : pagingStrategyNames.get(0).toString();
    }

    private String parsePagingType(@NotNull DialectDomainElement endpointsElement) {
        List pagingTypes = endpointsElement.getScalarByPropertyUri(AML_REST_SDK_PAGINATION_TYPE);
        return pagingTypes.isEmpty() ? null : pagingTypes.get(0).toString();
    }

    private ExpressionDescriptor parseResponseValueExtractionDescriptor(List<DialectDomainElement> valueExtraction) {
        if (!valueExtraction.isEmpty()) {
            return expressionParser.parseExpression(valueExtraction.get(0));
        }
        return null;
    }
}

