/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParameterParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTestConnectionParser;
import java.util.ArrayList;
import java.util.List;

public class DescriptorSecurityParser {
    private static final String AML_REST_SDK_SECURITY_SCHEME = "http://a.ml/vocabularies/rest-sdk#security";
    private static final String AML_REST_SDK_SECURITY_HEADERS = "http://a.ml/vocabularies/rest-sdk#securityHeaders";
    private static final String AML_REST_SDK_SECURITY_QUERY_PARAMETERS = "http://a.ml/vocabularies/rest-sdk#securityQueryParameters";
    private final DescriptorParameterParser descriptorParameterParser = new DescriptorParameterParser();
    private final DescriptorTestConnectionParser descriptorTestConnectionParser = new DescriptorTestConnectionParser();

    public List<SecuritySchemeDescriptor> parseSecurityScheme(DialectDomainElement element) {
        List securityDescriptors = element.getObjectPropertyUri(AML_REST_SDK_SECURITY_SCHEME);
        ArrayList<SecuritySchemeDescriptor> securitySchemeDescriptors = new ArrayList<SecuritySchemeDescriptor>(securityDescriptors.size());
        for (DialectDomainElement securityElement : securityDescriptors) {
            SecuritySchemeDescriptor securitySchemeDescriptor = new SecuritySchemeDescriptor(securityElement.localRefName(), this.parseHeaders(securityElement), this.parseQueryParameters(securityElement), DescriptorParserUtils.parseIgnore(securityElement), this.descriptorTestConnectionParser.parseTestConnection(securityElement));
            securitySchemeDescriptors.add(securitySchemeDescriptor);
        }
        return securitySchemeDescriptors;
    }

    private List<ParameterDescriptor> parseHeaders(DialectDomainElement securityElement) {
        List apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_SDK_SECURITY_HEADERS);
        return apiSpecElements.isEmpty() ? null : this.descriptorParameterParser.parseParameters(apiSpecElements);
    }

    private List<ParameterDescriptor> parseQueryParameters(DialectDomainElement securityElement) {
        List apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_SDK_SECURITY_QUERY_PARAMETERS);
        return apiSpecElements.isEmpty() ? null : this.descriptorParameterParser.parseParameters(apiSpecElements);
    }
}

