/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class DescriptorTestConnectionResponseValidationParser {
    private static final String RESPONSE_VALIDATION = "http://a.ml/vocabularies/rest-sdk#testConnectionResponseValidation";
    private static final String VALIDATION_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#testConnectionValidationExpression";
    private static final String ERROR_TEMPLATE_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#testConnectionErrorTemplate";
    private static final DescriptorExpressionParser descriptorExpressionParser = new DescriptorExpressionParser();

    public List<TestConnectionResponseValidationDescriptor> parseResponseValidations(DialectDomainElement testConnectionElement) {
        return this.getResponseValidationElements(testConnectionElement).stream().map(this::parseResponseValidation).collect(Collectors.toList());
    }

    private TestConnectionResponseValidationDescriptor parseResponseValidation(DialectDomainElement responseValidationElement) {
        if (responseValidationElement == null) {
            return null;
        }
        return new TestConnectionResponseValidationDescriptor(descriptorExpressionParser.parseExpression(this.getValidationExpressionElement(responseValidationElement)), descriptorExpressionParser.parseExpression(this.getErrorExpressionElement(responseValidationElement)));
    }

    private List<DialectDomainElement> getResponseValidationElements(@NotNull DialectDomainElement testConnectionElement) {
        return testConnectionElement.getObjectPropertyUri(RESPONSE_VALIDATION);
    }

    private DialectDomainElement getValidationExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
        return DescriptorParserUtils.getSingleObjectProperty(responseValidationElement, VALIDATION_EXPRESSION);
    }

    private DialectDomainElement getErrorExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
        return DescriptorParserUtils.getSingleObjectProperty(responseValidationElement, ERROR_TEMPLATE_EXPRESSION);
    }
}

