/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DescriptorTriggerParameterBindingParser {
    private static final String API_CONTRACT_URI_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#uriParameter";
    private static final String API_CONTRACT_QUERY_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#queryParameter";
    private static final String API_CONTRACT_HEADER = "http://a.ml/vocabularies.rest.sdk/apiContract#header";
    private static final String REQUEST_BODY_EXPRESSION = "http://a.ml/vocabularies/rest-sdk#triggerRequestBodyBinding";
    private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

    public TriggerParameterBindingsDescriptor parseParameterBindings(DialectDomainElement triggerParameterBindingDescriptor) {
        if (triggerParameterBindingDescriptor == null) {
            return null;
        }
        return new TriggerParameterBindingsDescriptor(this.parseBindings(triggerParameterBindingDescriptor.getObjectPropertyUri(API_CONTRACT_URI_PARAMETER)), this.parseBindings(triggerParameterBindingDescriptor.getObjectPropertyUri(API_CONTRACT_QUERY_PARAMETER)), this.parseBindings(triggerParameterBindingDescriptor.getObjectPropertyUri(API_CONTRACT_HEADER)), this.parseRequestBodyExpression(triggerParameterBindingDescriptor));
    }

    private String parseRequestBodyExpression(DialectDomainElement triggerParameterBindingDescriptor) {
        DialectDomainElement requestBodyExpression = DescriptorParserUtils.getSingleObjectProperty(triggerParameterBindingDescriptor, REQUEST_BODY_EXPRESSION);
        if (requestBodyExpression == null) {
            return null;
        }
        return expressionParser.parseExpression(requestBodyExpression).getExpression();
    }

    private List<TriggerParameterBindingDescriptor> parseBindings(List<DialectDomainElement> parameterBindingDescriptors) {
        if (parameterBindingDescriptors == null || parameterBindingDescriptors.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<TriggerParameterBindingDescriptor> result = new LinkedList<TriggerParameterBindingDescriptor>();
        for (DialectDomainElement binding : parameterBindingDescriptors) {
            result.add(this.parseBinding(binding));
        }
        return result;
    }

    private TriggerParameterBindingDescriptor parseBinding(DialectDomainElement binding) {
        return new TriggerParameterBindingDescriptor(DescriptorParserUtils.parseApiContractParamName(binding), expressionParser.parseContent(binding));
    }
}

