/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerWatermarkDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTriggerParameterBindingParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTriggerParametersParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorTriggerWatermarkParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DescriptorTriggerParser {
    private static final String AML_REST_SDK_TRIGGERS = "http://a.ml/vocabularies/rest-sdk#triggers";
    private static final String AML_REST_SDK_TRIGGER_PARAMETERS = "http://a.ml/vocabularies/rest-sdk#triggerParameters";
    private static final String AML_REST_SDK_TRIGGER_WATERMARK = "http://a.ml/vocabularies/rest-sdk#triggerWatermark";
    private static final String AML_REST_SDK_TRIGGER_BINDINGS = "http://a.ml/vocabularies/rest-sdk#triggerParameterBindings";
    private static final String AML_REST_SDK_TRIGGER_ITEMS = "http://a.ml/vocabularies/rest-sdk#triggerItems";
    private static final String AML_REST_SDK_TRIGGER_IDENTITY = "http://a.ml/vocabularies/rest-sdk#triggerIdentity";
    private static final String AML_REST_SDK_TRIGGER_ITEMS_EXTRACTION = "http://a.ml/vocabularies/rest-sdk#triggerItemsExtraction";
    private static final String AML_REST_SDK_TRIGGER_IDENTITY_EXTRACTION = "http://a.ml/vocabularies/rest-sdk#triggerIdentityExtraction";
    private static final DescriptorTriggerWatermarkParser watermarkParser = new DescriptorTriggerWatermarkParser();
    private static final DescriptorTriggerParametersParser parameterParser = new DescriptorTriggerParametersParser();
    private static final DescriptorTriggerParameterBindingParser bindingParser = new DescriptorTriggerParameterBindingParser();
    private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

    public List<TriggerDescriptor> parseTriggers(DialectDomainElement encodes) {
        List triggerDescriptors = encodes.getObjectPropertyUri(AML_REST_SDK_TRIGGERS);
        if (triggerDescriptors == null || triggerDescriptors.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<TriggerDescriptor> result = new LinkedList<TriggerDescriptor>();
        for (DialectDomainElement triggerDescriptor : triggerDescriptors) {
            result.add(this.parseTrigger(triggerDescriptor));
        }
        return result;
    }

    private TriggerDescriptor parseTrigger(DialectDomainElement triggerDescriptor) {
        return new TriggerDescriptor(DescriptorParserUtils.parseCoreName(triggerDescriptor), DescriptorParserUtils.parseApiContractPath(triggerDescriptor), DescriptorParserUtils.parseApiContractMethodAsMethodDescriptor(triggerDescriptor), DescriptorParserUtils.parseFriendlyName(triggerDescriptor), DescriptorParserUtils.parseCoreDescription(triggerDescriptor), this.parseParameters(triggerDescriptor), this.parseParameterBindings(triggerDescriptor), this.parseWatermark(triggerDescriptor), this.parseItemsExpression(triggerDescriptor), this.parseIdentityExpression(triggerDescriptor));
    }

    private String parseIdentityExpression(DialectDomainElement triggerDescriptor) {
        DialectDomainElement itemsDescriptor = DescriptorParserUtils.getSingleObjectProperty(triggerDescriptor, AML_REST_SDK_TRIGGER_IDENTITY);
        if (itemsDescriptor == null) {
            return null;
        }
        ExpressionDescriptor expressionDescriptor = expressionParser.parseExpression(DescriptorParserUtils.getSingleObjectProperty(itemsDescriptor, AML_REST_SDK_TRIGGER_IDENTITY_EXTRACTION));
        return expressionDescriptor.getExpression();
    }

    private String parseItemsExpression(DialectDomainElement triggerDescriptor) {
        DialectDomainElement itemsDescriptor = DescriptorParserUtils.getSingleObjectProperty(triggerDescriptor, AML_REST_SDK_TRIGGER_ITEMS);
        if (itemsDescriptor == null) {
            return null;
        }
        ExpressionDescriptor expressionDescriptor = expressionParser.parseExpression(DescriptorParserUtils.getSingleObjectProperty(itemsDescriptor, AML_REST_SDK_TRIGGER_ITEMS_EXTRACTION));
        return expressionDescriptor.getExpression();
    }

    private TriggerWatermarkDescriptor parseWatermark(DialectDomainElement triggerDescriptor) {
        DialectDomainElement watermarkDescriptor = DescriptorParserUtils.getSingleObjectProperty(triggerDescriptor, AML_REST_SDK_TRIGGER_WATERMARK);
        return watermarkParser.parseWatermark(watermarkDescriptor);
    }

    private List<TriggerParameterDescriptor> parseParameters(DialectDomainElement triggerDescriptor) {
        return parameterParser.parseParameters(triggerDescriptor.getObjectPropertyUri(AML_REST_SDK_TRIGGER_PARAMETERS));
    }

    private TriggerParameterBindingsDescriptor parseParameterBindings(DialectDomainElement triggerDescriptor) {
        return bindingParser.parseParameterBindings(DescriptorParserUtils.getSingleObjectProperty(triggerDescriptor, AML_REST_SDK_TRIGGER_BINDINGS));
    }
}

