/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParserUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorValueResolverBindingParser {
    private static final String AML_REST_SDK_VALUE_RESOLVER_BINDING = "http://a.ml/vocabularies/rest-sdk#valueResolverBinding";
    private static final String API_CONTRACT_URI_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#uriParameter";
    private static final String API_CONTRACT_QUERY_PARAMETER = "http://a.ml/vocabularies.rest.sdk/apiContract#queryParameter";
    private static final String API_CONTRACT_HEADER = "http://a.ml/vocabularies.rest.sdk/apiContract#header";
    private static final String AML_REST_SDK_VALUE_RESOLVER_BINDING_PARAMETER_VALUE = "http://a.ml/vocabularies/rest-sdk#valueResolverBindingParameterValue";
    private static final DescriptorExpressionParser expressionParser = new DescriptorExpressionParser();

    public ValueResolverBindingDescriptor parseBinding(DialectDomainElement valueResolver) {
        DialectDomainElement bindingElement = DescriptorParserUtils.getSingleObjectProperty(valueResolver, AML_REST_SDK_VALUE_RESOLVER_BINDING);
        if (bindingElement == null) {
            return null;
        }
        return new ValueResolverBindingDescriptor(this.parseBindingParameters(bindingElement.getObjectPropertyUri(API_CONTRACT_URI_PARAMETER)), this.parseBindingParameters(bindingElement.getObjectPropertyUri(API_CONTRACT_QUERY_PARAMETER)), this.parseBindingParameters(bindingElement.getObjectPropertyUri(API_CONTRACT_HEADER)));
    }

    private List<ValueResolverBindingParameterDescriptor> parseBindingParameters(List<DialectDomainElement> parameterElements) {
        if (parameterElements == null || parameterElements.isEmpty()) {
            return Collections.emptyList();
        }
        return parameterElements.stream().map(this::parseBindingParameter).collect(Collectors.toList());
    }

    private ValueResolverBindingParameterDescriptor parseBindingParameter(DialectDomainElement parameterElement) {
        return new ValueResolverBindingParameterDescriptor(DescriptorParserUtils.parseApiContractParamName(parameterElement), this.parseBindingParameterValue(parameterElement));
    }

    private ExpressionDescriptor parseBindingParameterValue(DialectDomainElement parameterElement) {
        DialectDomainElement bindingParameterValueElement = DescriptorParserUtils.getSingleObjectProperty(parameterElement, AML_REST_SDK_VALUE_RESOLVER_BINDING_PARAMETER_VALUE);
        return expressionParser.parseExpression(bindingParameterValueElement);
    }
}

