/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.writer;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APIUrlDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MultipleBaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.writer.YamlWriter;
import java.util.List;

public class DescriptorWriter {
    private static final String DESCRIPTOR_HEADER = "#% Rest Connector Descriptor 1.0";
    private static final String EMPTY_LINE = "";
    private static final String API_SPEC_KEY = "apiSpec";
    private static final String CONNECTOR_NAME_KEY = "connectorName";
    private static final String CONNECTOR_DESCRIPTION_KEY = "connectorDescription";
    private static final String CONNECTOR_GAV_KEY = "connectorGav";
    private static final String SKIP_OUTPUT_TYPE_VALIDATION_KEY = "skipOutputTypeValidation";
    private static final String VOID_OPERATION_KEY = "voidOperation";
    private static final String BASE_URI_KEY = "baseUri";
    private static final String PAGINATIONS_KEY = "paginations";
    private static final String ENDPOINTS_KEY = "endpoints";
    private static final String SECURITY_KEY = "security";
    private static final String GROUP_KEY = "groupId";
    private static final String ARTIFACT_KEY = "artifactId";
    private static final String VERSION_KEY = "version";
    private static final String URL_KEY = "url";
    private static final String BASE_URI_VALUE_KEY = "value";
    private static final String BASE_URI_TYPE_KEY = "type";
    private static final String BASE_URI_MAPPING_KEY = "mapping";
    private static final String MULTIPLE_BASE_URI_VALUE_KEY = "value";
    private static final String MULTIPLE_BASE_URI_DEFAULT_KEY = "default";
    private static final String ENDPOINT_OPERATIONS_KEY = "operations";
    private static final String ENDPOINT_IGNORED_KEY = "ignored";
    private static final String OPERATION_NAME_KEY = "name";
    private static final String OPERATION_DESCRIPTION_KEY = "description";
    private static final String OPERATION_DEFAULT_INPUT_MEDIA_TYPE_KEY = "inputMediaType";
    private static final String OPERATION_DEFAULT_OUTPUT_MEDIA_TYPE_KEY = "outputMediaType";
    private static final String OPERATION_EXPECTS_KEY = "expects";
    private static final String OPERATION_IGNORED_KEY = "ignored";
    private static final String REQUEST_HEADER_KEY = "header";
    private static final String REQUEST_QUERY_PARAM_KEY = "queryParameter";
    private static final String REQUEST_URI_PARAM_KEY = "uriParameter";
    private static final String PARAMETER_FRIENDLY_NAME_KEY = "friendlyName";
    private static final String PARAMETER_DESCRIPTION_KEY = "description";
    private final YamlWriter yamlWriter = new YamlWriter();

    private String getBoolean(boolean bool) {
        return bool ? "true" : "false";
    }

    private String getBoolean(Boolean bool) {
        if (bool == null) {
            return "false";
        }
        return bool != false ? "true" : "false";
    }

    private void write(DescriptorElement descriptorElement) {
        if (descriptorElement instanceof ParameterDescriptor) {
            this.write((ParameterDescriptor)descriptorElement);
        } else if (descriptorElement instanceof OperationDescriptor) {
            this.write((OperationDescriptor)descriptorElement);
        } else if (descriptorElement instanceof EndPointDescriptor) {
            this.write((EndPointDescriptor)descriptorElement);
        } else if (descriptorElement instanceof MultipleBaseUriDescriptor) {
            this.write((MultipleBaseUriDescriptor)descriptorElement);
        } else {
            throw new IllegalArgumentException("Can not write generic element");
        }
    }

    public String write(ConnectorDescriptor connectorDescriptor) {
        this.yamlWriter.addLine(DESCRIPTOR_HEADER).addLine(EMPTY_LINE);
        if (connectorDescriptor.getApiSpec() instanceof MavenGavDescriptor) {
            this.write((MavenGavDescriptor)connectorDescriptor.getApiSpec(), API_SPEC_KEY);
        } else {
            this.write((APIUrlDescriptor)connectorDescriptor.getApiSpec(), API_SPEC_KEY);
        }
        this.yamlWriter.addLine(EMPTY_LINE).addKeyValueLine(CONNECTOR_NAME_KEY, connectorDescriptor.getConnectorName()).addKeyValueLineIfNotEmpty(CONNECTOR_DESCRIPTION_KEY, connectorDescriptor.getConnectorDescription()).addLine(EMPTY_LINE);
        if (connectorDescriptor.getSkipOutputTypeValidation() != null) {
            this.yamlWriter.addKeyValueLine(SKIP_OUTPUT_TYPE_VALIDATION_KEY, this.getBoolean(connectorDescriptor.getSkipOutputTypeValidation()), "Set this to true if you want to add the type schema manually for all of the operations").addLine(EMPTY_LINE);
        }
        this.write(connectorDescriptor.getConnectorGav(), CONNECTOR_GAV_KEY);
        this.yamlWriter.addLine(EMPTY_LINE);
        this.write(connectorDescriptor.getBaseUri());
        if (!connectorDescriptor.getEndpoints().isEmpty()) {
            this.yamlWriter.addLine(EMPTY_LINE);
            this.writeList(connectorDescriptor.getEndpoints(), ENDPOINTS_KEY);
        }
        return this.yamlWriter.toString();
    }

    public void write(MavenGavDescriptor mavenGavDescriptor, String key) {
        this.yamlWriter.addKeyLine(key).addIndentation().addKeyValueLine(GROUP_KEY, mavenGavDescriptor.getGroupId()).addKeyValueLine(ARTIFACT_KEY, mavenGavDescriptor.getArtifactId()).addKeyValueLine(VERSION_KEY, mavenGavDescriptor.getVersion()).removeIndentation();
    }

    public void write(APIUrlDescriptor apiUrl, String key) {
        this.yamlWriter.addKeyLine(key).addIndentation().addKeyValueLine(URL_KEY, apiUrl.getUrl()).removeIndentation();
    }

    private void write(BaseUriDescriptor baseUri) {
        this.yamlWriter.addKeyLine(BASE_URI_KEY).addIndentation();
        if (baseUri.getValue() != null && !baseUri.getValue().isEmpty()) {
            this.yamlWriter.addKeyValueLine("value", baseUri.getValue());
        }
        this.yamlWriter.addKeyValueLine(BASE_URI_TYPE_KEY, baseUri.getType()).removeIndentation();
        this.writeList(baseUri.getMapping(), BASE_URI_MAPPING_KEY);
    }

    private <T extends DescriptorElement> void writeList(List<T> elements, String key) {
        if (elements != null && !elements.isEmpty()) {
            this.yamlWriter.addKeyLine(key).addIndentation();
            for (DescriptorElement element : elements) {
                this.write(element);
            }
            this.yamlWriter.removeIndentation();
        }
    }

    private void write(MultipleBaseUriDescriptor multipleBaseUriDescriptor) {
        this.yamlWriter.addKeyLine(multipleBaseUriDescriptor.getName()).addIndentation().addKeyValueLine("value", multipleBaseUriDescriptor.getValue()).addKeyValueLine(MULTIPLE_BASE_URI_DEFAULT_KEY, this.getBoolean(multipleBaseUriDescriptor.isDefault())).removeIndentation();
    }

    private void write(EndPointDescriptor endPointDescriptor) {
        this.yamlWriter.addKeyLine(endPointDescriptor.getPath()).addIndentation().addKeyValueLine("ignored", this.getBoolean(endPointDescriptor.isIgnored()));
        this.writeList(endPointDescriptor.getOperations(), ENDPOINT_OPERATIONS_KEY);
        this.yamlWriter.removeIndentation();
    }

    private void write(OperationDescriptor operation) {
        this.yamlWriter.addKeyLine(operation.getMethod()).addIndentation().addKeyValueLineIfNotEmpty(OPERATION_NAME_KEY, operation.getName()).addKeyValueLineIfNotEmpty("description", operation.getDescription()).addKeyValueLineIfNotEmpty(OPERATION_DEFAULT_INPUT_MEDIA_TYPE_KEY, operation.getInputMediaType()).addKeyValueLineIfNotEmpty(OPERATION_DEFAULT_OUTPUT_MEDIA_TYPE_KEY, operation.getOutputMediaType());
        if (operation.getSkipOutputTypeValidation() != null) {
            this.yamlWriter.addKeyValueLine(SKIP_OUTPUT_TYPE_VALIDATION_KEY, this.getBoolean(operation.getSkipOutputTypeValidation()), "Set this to true if you want to add the type schema manually");
        }
        if (operation.getVoidOperation() != null) {
            this.yamlWriter.addKeyValueLine(VOID_OPERATION_KEY, this.getBoolean(operation.getVoidOperation()), "Set this to true if you want this operation response to be empty");
        }
        if (operation.getExpects() != null) {
            this.write(operation.getExpects());
        }
        this.yamlWriter.addKeyValueLine("ignored", this.getBoolean(operation.isIgnored())).removeIndentation();
    }

    private void write(RequestDescriptor requestDescriptor) {
        if (requestDescriptor.getHeader() != null && !requestDescriptor.getHeader().isEmpty() || requestDescriptor.getQueryParameter() != null && !requestDescriptor.getQueryParameter().isEmpty() || requestDescriptor.getUriParameter() != null && !requestDescriptor.getUriParameter().isEmpty()) {
            this.yamlWriter.addKeyLine(OPERATION_EXPECTS_KEY).addIndentation();
            this.writeList(requestDescriptor.getHeader(), REQUEST_HEADER_KEY);
            this.writeList(requestDescriptor.getQueryParameter(), REQUEST_QUERY_PARAM_KEY);
            this.writeList(requestDescriptor.getUriParameter(), REQUEST_URI_PARAM_KEY);
            this.yamlWriter.removeIndentation();
        }
    }

    private void write(ParameterDescriptor parameterDescriptor) {
        this.yamlWriter.addKeyLine(parameterDescriptor.getParamName()).addIndentation().addKeyValueLine(PARAMETER_FRIENDLY_NAME_KEY, parameterDescriptor.getFriendlyName()).addKeyValueLineIfNotEmpty("description", parameterDescriptor.getDescription()).removeIndentation();
    }
}

