/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.descriptor.writer;

import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class YamlWriter {
    private static final String INDENTATION_VALUE = " ";
    private static final int INDENTATION_MULTIPLIER = 2;
    private static final String COMMENT_VALUE = "#";
    private static final String QUOTE_VALUE = "'";
    private static final String ESCAPED_QUOTE_VALUE = "''";
    private static final String WHITE_SPACE = " ";
    private static final Pattern NEEDS_ESCAPING_PATTERN = Pattern.compile("[\\[\\]\\#\\:\\{\\}\\\"\\'\\>\\?\\@]");
    private final StringBuilder stringBuilder = new StringBuilder();
    private int indentationLevel = 0;

    public YamlWriter addIndentation() {
        ++this.indentationLevel;
        return this;
    }

    public YamlWriter removeIndentation() {
        --this.indentationLevel;
        if (this.indentationLevel < 0) {
            this.indentationLevel = 0;
        }
        return this;
    }

    public YamlWriter addKeyLine(@NotNull String key) {
        return this.addKeyLine(key, null);
    }

    public YamlWriter addKeyLine(@NotNull String key, String comment) {
        return this.addLine(this.buildKeyValueCommentLine(key, null, comment));
    }

    public YamlWriter addKeyValueLineIfNotEmpty(@NotNull String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return this.addKeyValueLine(key, value, null);
        }
        return this;
    }

    public YamlWriter addKeyValueLine(@NotNull String key, String value) {
        return this.addKeyValueLine(key, value, null);
    }

    public YamlWriter addKeyValueLine(@NotNull String key, String value, String comment) {
        return this.addLine(this.buildKeyValueCommentLine(key, value, comment));
    }

    private String buildKeyValueCommentLine(@NotNull String key, String value, String comment) {
        String line = key + ":";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            line = line + " " + this.buildValueString(value);
        }
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            line = line + " #" + comment;
        }
        return line;
    }

    private String buildValueString(String value) {
        if (value.contains(System.lineSeparator())) {
            String[] lines;
            StringBuilder valueLine = new StringBuilder("|");
            valueLine.append(System.lineSeparator());
            this.addIndentation();
            for (String line : lines = value.split(System.lineSeparator())) {
                if (!line.isEmpty()) {
                    valueLine.append(this.getIndentationString()).append(line.replaceAll("^\\s+", ""));
                }
                valueLine.append(System.lineSeparator());
            }
            valueLine.delete(valueLine.lastIndexOf(System.lineSeparator()), valueLine.length());
            this.removeIndentation();
            return valueLine.toString();
        }
        return this.escapeValue(value);
    }

    private String escapeValue(String value) {
        if (NEEDS_ESCAPING_PATTERN.matcher(value).find()) {
            return QUOTE_VALUE + value.replace(QUOTE_VALUE, ESCAPED_QUOTE_VALUE) + QUOTE_VALUE;
        }
        return value;
    }

    public YamlWriter addLine(String line) {
        this.stringBuilder.append(this.getIndentationString()).append(line).append(System.lineSeparator());
        return this;
    }

    private String getIndentationString() {
        StringBuilder indentationString = new StringBuilder();
        for (int e = 0; e < this.indentationLevel; ++e) {
            for (int i = 0; i < 2; ++i) {
                indentationString.append(" ");
            }
        }
        return indentationString.toString();
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

