/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating;

import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.templating.TemplateEntity;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;

public abstract class VelocityTemplateEntity
extends TemplateEntity {
    private static final ToolManager velocityToolManager = new ToolManager();
    protected final Path outputDir;
    private final VelocityContext velocityContext;

    protected VelocityTemplateEntity(Path outputDir) {
        this.outputDir = outputDir;
        this.velocityContext = this.newVelocityContext();
    }

    protected void applyTemplate(String templateVm, Path outputPath) throws TemplatingException {
        outputPath.getParent().toFile().mkdirs();
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputPath.toFile()));){
            Template template = ve.getTemplate(templateVm, "UTF-8");
            template.merge((Context)this.velocityContext, (Writer)writer);
        }
        catch (IOException e) {
            throw new TemplatingException("Error when applying template", e);
        }
    }

    private VelocityContext newVelocityContext() {
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.put("StringUtils", StringUtils.class);
        context.internalPut("model", (Object)this);
        return context;
    }

    static {
        velocityToolManager.configure("velocity-tools.xml");
    }
}

