/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkContentNameGenerator;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkInputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.util.FileGenerationUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SdkContent
extends JavaTemplateEntity {
    private final SdkInputMetadataResolver inputMetadataResolver;
    private final String contentParameterJavaName;
    private final boolean primary;
    private final TypeDefinition typeDefinition;

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        this(outputDir, connectorModel, sdkConnector, operation, operation.getInputMetadata(), SdkContentKind.INPUT_METADATA, "", true, runConfiguration);
    }

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, SdkContentKind contentType, String partName, boolean primary, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        FileGenerationUtils.SchemaNameType schemaNameType = contentType.equals((Object)SdkContentKind.INPUT_METADATA) ? FileGenerationUtils.SchemaNameType.INPUT : FileGenerationUtils.SchemaNameType.PART;
        this.inputMetadataResolver = new SdkInputMetadataResolver(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName, runConfiguration);
        this.contentParameterJavaName = SdkContentNameGenerator.getContentName(runConfiguration, this.inputMetadataResolver, contentType, partName);
        this.primary = primary;
    }

    private TypeName getTypeName() {
        return ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{InputStream.class});
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.inputMetadataResolver.applyTemplates();
    }

    public ParameterSpec generateContentParameter() {
        AnnotationSpec summaryAnnotation;
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.contentParameterJavaName, (Modifier[])new Modifier[0]).addAnnotation(this.generateContentAnnotation());
        AnnotationSpec displayNameAnnotation = this.generateDisplayNameAnnotation();
        if (displayNameAnnotation != null) {
            paramSpecBuilder.addAnnotation(displayNameAnnotation);
        }
        if ((summaryAnnotation = this.generateSummaryAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        if (this.inputMetadataResolver != null && this.inputMetadataResolver.getRequiresMetadataResolver()) {
            paramSpecBuilder.addAnnotation(this.generateMetadataResolverAnnotation());
        }
        return paramSpecBuilder.build();
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        String displayName = this.typeDefinition.getDisplayName();
        if (RestSdkUtils.isBlank((CharSequence)displayName)) {
            return null;
        }
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{displayName}).build();
    }

    private AnnotationSpec generateSummaryAnnotation() {
        String summary = this.typeDefinition.getDescription();
        if (RestSdkUtils.isBlank((CharSequence)summary)) {
            return null;
        }
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{summary}).build();
    }

    private AnnotationSpec generateMetadataResolverAnnotation() {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.inputMetadataResolver.getPackage(), (String)this.inputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).addMember("primary", "$L", new Object[]{this.primary}).build();
    }

    public String getContentParameterJavaName() {
        return this.contentParameterJavaName;
    }

    public static enum SdkContentKind {
        INPUT_METADATA,
        PART;

    }
}

