/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkMarkerPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkMultipartOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkOffsetPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkPageNumberPaginationOperation;
import java.nio.file.Path;

public class SdkOperationFactory {
    public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        if (operation.hasPagination()) {
            String pagingType = connectorModel.getPagination(operation.getPagination()).getType();
            if ("offset".equalsIgnoreCase(pagingType)) {
                return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if ("marker".equalsIgnoreCase(pagingType)) {
                return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if ("pageNumber".equalsIgnoreCase(pagingType)) {
                return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
        }
        if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        }
        return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }
}

