/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.RestValueProvider;
import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.internal.templating.sdk.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;

public class SdkValueProvider
extends JavaTemplateEntity {
    private static final String GET_TYPED_VALUE_OR_NULL_METHOD = "getTypedValueOrNull";
    private static final String GET_PATH_TEMPLATE_METHOD = "getPathTemplate";
    private static final String GET_REQUEST_BUILDER_METHOD = "getRequestBuilder";
    private static final String GET_PARAMETER_BINDING_METHOD = "getParameterBinding";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "binding";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String PARAMETER_VALUES_LOCAL_VARIABLE = "parameterValues";
    private static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    private static final String ITEM_VALUE_EXPRESSION_FIELD = "ITEM_VALUE_EXPRESSION";
    private static final String ITEM_NAME_EXPRESSION_FIELD = "ITEM_NAME_EXPRESSION";
    private static final String PATH_TEMPLATE_FIELD = "PATH";
    private final SdkOperation sdkOperation;
    private final Parameter parameter;
    private final ValueResolver valueResolverModel;
    private Map<String, SdkParameter> operationParameters = null;

    public SdkValueProvider(Path outputDir, ConnectorModel connectorModel, Parameter parameter, SdkOperation operation, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.parameter = parameter;
        this.sdkOperation = operation;
        this.valueResolverModel = connectorModel.getValueResolvers().stream().filter(x -> x.getName().equals(parameter.getValueResolverReference().getId())).findFirst().orElse(null);
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateValueProviderClass();
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.metadata.values";
    }

    public String getJavaClassName() {
        return this.sdkOperation.getJavaClassName() + JavaUtils.getJavaUpperCamelNameFromXml(this.parameter.getInternalName()) + "ValueProvider";
    }

    private void generateValueProviderClass() throws TemplatingException {
        TypeSpec.Builder valueProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(RestValueProvider.class).addMethod(this.generateConstructor()).addMethod(this.generateGetPathTemplateMethod()).addMethod(this.generateGetRequestBuilderMethod()).addMethod(this.generateGetParameterBindingMethod()).addMethod(this.generateGetParameterValuesMethod());
        this.addClassConstants(valueProviderClassBuilder);
        this.addParameters(valueProviderClassBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(valueProviderClassBuilder.build(), this.getPackage());
        javaFileBuilder.addStaticImport(RestSdkUtils.class, new String[]{GET_TYPED_VALUE_OR_NULL_METHOD});
        this.writeJavaFile(javaFileBuilder.build());
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($L, $L, $L)", new Object[]{ITEMS_EXPRESSION_FIELD, ITEM_VALUE_EXPRESSION_FIELD, ITEM_NAME_EXPRESSION_FIELD});
        return constructorBuilder.build();
    }

    private MethodSpec generateGetPathTemplateMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PATH_TEMPLATE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $L", new Object[]{PATH_TEMPLATE_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetRequestBuilderMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BUILDER_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RestRequestBuilder.class).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]);
        methodBuilder.addStatement("return new $T(connection.getBaseUri(), path, $T.$L)", new Object[]{RestRequestBuilder.class, HttpConstants.Method.class, this.valueResolverModel.getMethod().name().toUpperCase()});
        return methodBuilder.build();
    }

    private MethodSpec generateGetParameterBindingMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_BINDING_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RequestParameterBinding.class).addAnnotation(Override.class);
        if (this.valueResolverModel.getParameterBindings() != null && this.valueResolverModel.getParameterBindings().size() > 0) {
            methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{RequestParameterBinding.class, PARAMETER_BINDING_LOCAL_VARIABLE});
            for (ParameterBinding binding : this.valueResolverModel.getParameterBindings()) {
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression()});
            }
            methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        } else {
            methodBuilder.addStatement("return new $1T()", new Object[]{RequestParameterBinding.class});
        }
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported: " + (Object)((Object)binding.getParameterType()));
    }

    private MethodSpec generateGetParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        if (!this.valueResolverModel.getParameters().isEmpty()) {
            methodBuilder.addStatement("final $T $L = new $T()", new Object[]{this.getParameterValuesMultiMapType(), PARAMETER_VALUES_LOCAL_VARIABLE, MultiMap.class});
            Map<String, SdkParameter> operationSdkParameter = this.getOperationValueResolverParameters();
            for (String parameterName : operationSdkParameter.keySet()) {
                SdkParameter sdkParameter = operationSdkParameter.get(parameterName);
                methodBuilder.addStatement("$L.put($S, $L($L))", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE, parameterName, GET_TYPED_VALUE_OR_NULL_METHOD, sdkParameter.getJavaName()});
            }
            methodBuilder.addStatement("return $L", new Object[]{PARAMETER_VALUES_LOCAL_VARIABLE});
        } else {
            methodBuilder.addStatement("return new $T()", new Object[]{this.getParameterValuesMultiMapType()});
        }
        return methodBuilder.build();
    }

    private Map<String, SdkParameter> getOperationValueResolverParameters() {
        if (this.operationParameters != null) {
            return this.operationParameters;
        }
        HashMap<String, SdkParameter> operationParameters = new HashMap<String, SdkParameter>();
        for (ValueResolverParameter valueResolverParameter : this.valueResolverModel.getParameters()) {
            String parameterArgument = this.parameter.getValueResolverReference().getArguments().get(valueResolverParameter.getName());
            String[] argumentValue = parameterArgument.split("\\.");
            String parameterTypeString = argumentValue[0];
            String parameterName = argumentValue[1];
            ParameterType parameterType = parameterTypeString.startsWith("uriParameter") ? ParameterType.URI : (parameterTypeString.startsWith("queryParameter") ? ParameterType.QUERY : ParameterType.HEADER);
            operationParameters.put(valueResolverParameter.getName(), this.sdkOperation.getSdkParameter(parameterType, parameterName));
        }
        this.operationParameters = operationParameters;
        return this.operationParameters;
    }

    private ParameterizedTypeName getParameterValuesMultiMapType() {
        ParameterizedTypeName wildcardTypedValueType = ParameterizedTypeName.get((ClassName)ClassName.get(TypedValue.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return ParameterizedTypeName.get((ClassName)ClassName.get(MultiMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), wildcardTypedValueType});
    }

    private void addClassConstants(TypeSpec.Builder valueProviderClassBuilder) {
        valueProviderClassBuilder.addField(this.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.valueResolverModel.getValueExpression())).addField(this.getConstantStringField(ITEM_VALUE_EXPRESSION_FIELD, this.valueResolverModel.getItemsExpression())).addField(this.getConstantStringField(ITEM_NAME_EXPRESSION_FIELD, this.valueResolverModel.getDisplayNameExpression())).addField(this.getConstantStringField(PATH_TEMPLATE_FIELD, this.valueResolverModel.getPath()));
    }

    private void addParameters(TypeSpec.Builder valueResolverClassBuilder) {
        Map<String, SdkParameter> operationSdkParameters = this.getOperationValueResolverParameters();
        for (String parameterName : operationSdkParameters.keySet()) {
            valueResolverClassBuilder.addField(this.getParameterFieldSpec(operationSdkParameters.get(parameterName)));
        }
    }

    private FieldSpec getParameterFieldSpec(SdkParameter sdkParameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)sdkParameter.getTypeName(), (String)sdkParameter.getJavaName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        return fieldBuilder.build();
    }
}

