/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.util;

import amf.MessageStyle;
import amf.ProfileName;
import amf.client.AMF;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.DialectInstance;
import amf.client.parse.Aml10Parser;
import amf.client.resolve.Resolver;
import amf.client.validate.ValidationReport;
import com.google.common.io.Files;
import com.mulesoft.connectivity.rest.sdk.exception.ModelGenerationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;

public final class AMFWrapper {
    private static final Semaphore initializationSemaphore = new Semaphore(1);
    private static boolean amfInitialized = false;
    private static final String REST_SDK_AML_RESOURCES_PATH = "com/mulesoft/connectivity/rest/aml";
    private static final String DIALECTS_FOLDER = "/dialects";
    private static final String VOCABULARIES_FOLDER = "/vocabularies";
    private static final String REST_SDK_VOCABULARY_FILE_NAME = "rest_sdk_vocabulary.yaml";
    private static final String REST_SDK_DIALECT_FILE_NAME = "rest_sdk_dialect.yaml";
    private static final String DIALECT_RESOURCE_PATH = "com/mulesoft/connectivity/rest/aml/dialects/rest_sdk_dialect.yaml";
    private static final String VOCABULARY_RESOURCE_PATH = "com/mulesoft/connectivity/rest/aml/vocabularies/rest_sdk_vocabulary.yaml";

    private AMFWrapper() {
    }

    public static void initialize() throws ModelGenerationException {
        if (!amfInitialized) {
            try {
                initializationSemaphore.acquire();
                if (!amfInitialized) {
                    AMF.init().get();
                    AMFWrapper.registerDialect();
                }
            }
            catch (ExecutionException e) {
                throw new ModelGenerationException("Error initializing AMF.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ModelGenerationException("Error initializing AMF.", e);
            }
            finally {
                initializationSemaphore.release();
            }
            amfInitialized = true;
        }
    }

    private static void registerDialect() throws ModelGenerationException {
        try {
            InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream(DIALECT_RESOURCE_PATH);
            InputStream vocabulary = Thread.currentThread().getContextClassLoader().getResourceAsStream(VOCABULARY_RESOURCE_PATH);
            Objects.requireNonNull(source);
            Objects.requireNonNull(vocabulary);
            File baseTmpDir = Files.createTempDir();
            File baseDir = new File(baseTmpDir.toPath() + DIALECTS_FOLDER);
            File baseDirVoc = new File(baseTmpDir.toPath() + VOCABULARIES_FOLDER);
            File tmpDialect = new File(baseDir, REST_SDK_DIALECT_FILE_NAME);
            File tempVocabulary = new File(baseDirVoc, REST_SDK_VOCABULARY_FILE_NAME);
            FileUtils.copyInputStreamToFile((InputStream)vocabulary, (File)tempVocabulary);
            FileUtils.copyInputStreamToFile((InputStream)source, (File)tmpDialect);
            AMF.registerDialect((String)tmpDialect.toURI().toURL().toString()).get();
        }
        catch (IOException | ExecutionException e) {
            throw new ModelGenerationException("Could not register dialect.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could not register dialect.", e);
        }
    }

    public static DialectInstance parseConnectorDescriptor(@NotNull File connectorDescriptor) throws ModelGenerationException {
        DialectInstance dialectInstance;
        AMFWrapper.initialize();
        try {
            dialectInstance = (DialectInstance)new Aml10Parser().parseFileAsync(connectorDescriptor.toURI().toURL().toString()).get();
        }
        catch (MalformedURLException | ExecutionException e) {
            throw new ModelGenerationException("Could not parse connector descriptor.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could not parse connector descriptor.", e);
        }
        dialectInstance = (DialectInstance)new Resolver("AML 1.0").resolve((BaseUnit)dialectInstance);
        AMFWrapper.validate(dialectInstance);
        return Objects.requireNonNull(dialectInstance);
    }

    public static void validate(DialectInstance metadata) throws ModelGenerationException {
        ValidationReport report;
        try {
            report = (ValidationReport)AMF.validate((BaseUnit)metadata, (ProfileName)ProfileName.apply((String)"Rest Connector Descriptor 1.0"), (MessageStyle)MessageStyle.apply((String)"AMF")).get();
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new ModelGenerationException("Could not validate connector descriptor", e);
        }
        if (!report.conforms()) {
            throw new ModelGenerationException(report.toString());
        }
    }
}

