/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.util;

import com.google.common.base.Charsets;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.OperationNamingUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class FileGenerationUtils {
    private static final String JSON_REF_PROPERTY = "$ref";
    private static final Pattern TYPE_DEF_NAME_PATTERN = Pattern.compile("#/definitions/(.*)");

    public static void writeSchema(TypeSchema source, Path outputDir, String schemaName) {
        try {
            File file = outputDir.resolve(schemaName).toFile();
            if (file.exists()) {
                return;
            }
            String schemaString = source.getRawSchema();
            if (source instanceof JsonTypeSchema) {
                JSONObject jObject = new JSONObject(schemaString);
                schemaString = jObject.toString(2);
            }
            FileUtils.writeStringToFile((File)file, (String)schemaString, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Path %s is invalid.", outputDir), e);
        }
    }

    public static String generateSchemaName(TypeSchema source, ConnectorOperation operation, SchemaNameType nameType, String partName, Path outputDir, Map<TypeSchema, String> typeSchemaNames) {
        String refSchemaName;
        if (typeSchemaNames.containsKey(source)) {
            return typeSchemaNames.get(source);
        }
        String jsonRef = FileGenerationUtils.getJsonRefProperty(source);
        if (jsonRef != null && !outputDir.resolve(refSchemaName = XmlUtils.getXmlName(jsonRef) + "." + FileGenerationUtils.getExtension(source)).toFile().exists()) {
            typeSchemaNames.put(source, refSchemaName);
            return refSchemaName;
        }
        String suffix = FileGenerationUtils.getSchemaSuffix(source, nameType, partName);
        String resourcesSchemaName = (String.join((CharSequence)"-", OperationNamingUtils.getPathResources(operation.getPath())) + suffix).toLowerCase();
        if (!outputDir.resolve(resourcesSchemaName).toFile().exists()) {
            typeSchemaNames.put(source, resourcesSchemaName);
            return resourcesSchemaName;
        }
        String operationSchemaName = operation.getInternalName() + suffix;
        if (!outputDir.resolve(operationSchemaName).toFile().exists()) {
            typeSchemaNames.put(source, operationSchemaName);
            return operationSchemaName;
        }
        throw new IllegalArgumentException("Could not generate name for schema.");
    }

    private static String getJsonRefProperty(TypeSchema source) {
        String name;
        String ref;
        Matcher refMatcher;
        JSONObject jsonSchema;
        if ((source instanceof JsonTypeSchema || source instanceof CustomTypeSchema) && (jsonSchema = new JSONObject(source.getRawSchema())).keySet().contains(JSON_REF_PROPERTY) && (refMatcher = TYPE_DEF_NAME_PATTERN.matcher(ref = jsonSchema.getString(JSON_REF_PROPERTY))).find() && !(name = refMatcher.group(1)).equalsIgnoreCase("root") && !name.equalsIgnoreCase("schema")) {
            return name;
        }
        return null;
    }

    private static String getSchemaSuffix(TypeSchema source, SchemaNameType nameType, String partName) {
        String schemaSuffix = "";
        switch (nameType) {
            case INPUT: {
                schemaSuffix = "-input-schema.";
                break;
            }
            case OUTPUT: {
                schemaSuffix = "-output-schema.";
                break;
            }
            case PART: {
                schemaSuffix = "-part-input-schema.";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)partName)) {
            schemaSuffix = "-" + XmlUtils.getXmlName(partName) + schemaSuffix;
        }
        return schemaSuffix + FileGenerationUtils.getExtension(source);
    }

    private static String getExtension(TypeSchema source) {
        if (source instanceof XmlTypeSchema) {
            return "xsd";
        }
        if (source instanceof JsonTypeSchema || source instanceof CustomTypeSchema) {
            return "json";
        }
        throw new IllegalArgumentException("Type Schema class doesn't support typeSchema generation.");
    }

    public static boolean supportsSchemaGeneration(TypeSchema source) {
        return source instanceof XmlTypeSchema || source instanceof JsonTypeSchema || source instanceof CustomTypeSchema;
    }

    public static enum SchemaNameType {
        INPUT,
        OUTPUT,
        PART;

    }
}

