/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BaseJavaPackageMustBeValidRule
extends PreValidationRule {
    public BaseJavaPackageMustBeValidRule() {
        super("Descriptor baseJavaPackage must ve a valid java package name", "When present in the connector descriptor, baseJavaPackage property must be a valid java package.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String javaPackage = connectorDescriptor.getBaseJavaPackage();
        if (StringUtils.isBlank((CharSequence)javaPackage)) {
            return validationResults;
        }
        String validJavaPackage = JavaUtils.removeJavaPackageUnwantedCharacters(javaPackage);
        if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "Descriptor baseJavaPackage");
    }
}

