/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConnectorNameMustBeFriendlyRule
extends PreValidationRule {
    public ConnectorNameMustBeFriendlyRule() {
        super("connectorName property seems not to be a friendly name", "The connectorName declared in the descriptor should be a human readable name separated with spaces.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String connectorName = connectorDescriptor.getConnectorName();
        if (StringUtils.isNotBlank((CharSequence)connectorName) && !NamingUtil.isFriendlyName(connectorName)) {
            validationResults.add(this.getValidationError(connectorName));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(String name) {
        return new ValidationResult(this, "connectorName : " + name);
    }
}

