/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorPathMustExistInApiRule
extends PreValidationRule {
    public DescriptorPathMustExistInApiRule() {
        super("Descriptor PATHs must be present in the API spec", "Any path declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List descriptorPaths = connectorDescriptor.getEndpoints().stream().map(EndPointDescriptor::getPath).collect(Collectors.toList());
        List apiPaths = apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().collect(Collectors.toList());
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (String descriptorPath : descriptorPaths) {
            if (!apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(descriptorPath))) continue;
            validationResults.add(new ValidationResult(this, "Path: " + descriptorPath));
        }
        return validationResults;
    }
}

