/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.LinkedList;
import java.util.List;

public class GavArtifactIdMustBeValidRule
extends PreValidationRule {
    public GavArtifactIdMustBeValidRule() {
        super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId", "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        String validArtifactId;
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String artifactId = connectorDescriptor.getConnectorGav().getArtifactId();
        if (!artifactId.equalsIgnoreCase(validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters(artifactId))) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "'artifactId' property declared in the connector descriptor's 'connectorGav' property");
    }
}

