/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NoOutputMediaTypeDefinedRule
extends PreValidationRule {
    public NoOutputMediaTypeDefinedRule() {
        super("Defining a media type for the operations output type is mandatory", "If an operation defines an output type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getDefaultOutputMediaType())) {
            return Collections.emptyList();
        }
        LinkedList<ValidationResult> allErrors = new LinkedList<ValidationResult>();
        apiModel.getOperationsModel().stream().filter(x -> !x.getOutputMetadataModel().isEmpty()).filter(x -> !this.outputMediaTypeDefinedInAPISpec((APIOperationModel)x)).filter(x -> !this.outputMediaTypeDefinedInDescriptor((APIOperationModel)x, connectorDescriptor)).map(this::getValidationErrorForApiSpec).forEach(allErrors::add);
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            endpoint.getOperations().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getOutputTypeSchema())).filter(x -> StringUtils.isBlank((CharSequence)x.getOutputMediaType())).filter(x -> !this.outputMediaTypeDefinedInAPISpec(apiModel, endpoint.getPath(), x.getMethod())).map(x -> this.getValidationErrorForDescriptor(endpoint.getPath(), x.getMethod())).forEach(allErrors::add);
        }
        return allErrors;
    }

    private boolean outputMediaTypeDefinedInAPISpec(APIOperationModel apiOperation) {
        return apiOperation.getOutputMetadataModel().stream().anyMatch(x -> x.getMediaType() != null);
    }

    private boolean outputMediaTypeDefinedInAPISpec(APIModel apiModel, String path, String method) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).flatMap(x -> x.getOutputMetadataModel().stream()).anyMatch(x -> x.getMediaType() != null);
    }

    private boolean outputMediaTypeDefinedInDescriptor(APIOperationModel apiOperationModel, ConnectorDescriptor descriptor) {
        OperationDescriptor operationDescriptor = descriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputMediaType());
    }

    private ValidationResult getValidationErrorForApiSpec(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name() + " defined in the API spec";
        return new ValidationResult(this, location);
    }

    private ValidationResult getValidationErrorForDescriptor(String path, String method) {
        String location = "Operation with PATH: " + path + " and METHOD: " + method + " defined in the Connector Descriptor";
        return new ValidationResult(this, location);
    }
}

