/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public OperationMustDeclareResponseBodyRule() {
        super("Operations must declare a response body", "GET, POST, PATCH and OPTIONS operations defined in the API spec must declare a response body and a type for that body. If they don't the connector descriptor must skip this check, define a response body for the operation, or declare it as void.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = connectorModel.getOperations().stream().filter(x -> this.httpMethodApplies(x.getHttpMethod())).filter(x -> x.getOutputMetadata() == null || x.getOutputMetadata() instanceof EmptyTypeDefinition).map(x -> this.getApiOperationModel(apiModel, (ConnectorOperation)x)).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> !this.validationSkipped(connectorModel, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.isVoidOperation(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(this::getValidationError).collect(Collectors.toList());
    }

    private APIOperationModel getApiOperationModel(APIModel apiModel, ConnectorOperation connectorOperation) {
        APIOperationModel apiOperationModel = apiModel.getOperationsModel().stream().filter(x -> connectorOperation.getPath().equalsIgnoreCase(x.getPath())).filter(x -> connectorOperation.getHttpMethod().equalsIgnoreCase(x.getHttpMethod().name())).findFirst().orElse(null);
        return Objects.requireNonNull(apiOperationModel);
    }

    private boolean isVoidOperation(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation() != false;
    }

    private boolean httpMethodApplies(String httpMethod) {
        return httpMethod.equalsIgnoreCase(HTTPMethod.GET.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.POST.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.PATCH.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.OPTIONS.name());
    }

    private boolean validationSkipped(ConnectorModel connectorModel, APIOperationModel apiOperationModel) {
        boolean globalSkip = connectorModel.getSkipOutputTypeValidation() != null && connectorModel.getSkipOutputTypeValidation() != false;
        ConnectorOperation connectorOperation = connectorModel.getOperations().stream().filter(x -> x.getHttpMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
        if (connectorOperation == null) {
            return false;
        }
        if (connectorOperation.getSkipOutputTypeValidation() == null) {
            return globalSkip;
        }
        return connectorOperation.getSkipOutputTypeValidation();
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

