/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class OperationNameMustBeFriendlyRule
extends PostValidationRule {
    public OperationNameMustBeFriendlyRule() {
        super("Operation display name seems not to be a friendly name", "The displayName should be a human readable name separated with spaces.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().filter(x -> !NamingUtil.isFriendlyName(x.getDisplayName())).map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
        String location = "Operation with PATH: " + connectorOperation.getPath() + " and METHOD: " + connectorOperation.getHttpMethod() + " display name is : " + connectorOperation.getDisplayName();
        return new ValidationResult(this, location);
    }
}

