/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PagedOperationsOperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public PagedOperationsOperationMustDeclareResponseBodyRule() {
        super("Paged Operations must declare a response body", "All paginated operations must declare a an output type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = connectorModel.getOperations().stream().filter(x -> x.getOutputMetadata() == null || x.getOutputMetadata() instanceof EmptyTypeDefinition).map(x -> this.getApiOperationModel(apiModel, (ConnectorOperation)x)).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> this.operationIsPaginated(connectorDescriptor, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.typeDefinedInDescriptor(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(this::getValidationError).collect(Collectors.toList());
    }

    private APIOperationModel getApiOperationModel(APIModel apiModel, ConnectorOperation connectorOperation) {
        APIOperationModel apiOperationModel = apiModel.getOperationsModel().stream().filter(x -> connectorOperation.getPath().equalsIgnoreCase(x.getPath())).filter(x -> connectorOperation.getHttpMethod().equalsIgnoreCase(x.getHttpMethod().name())).findFirst().orElse(null);
        return Objects.requireNonNull(apiOperationModel);
    }

    private boolean typeDefinedInDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema());
    }

    private boolean operationIsPaginated(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination());
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

