/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ParameterNameMustBeFriendlyRule
extends PreValidationRule {
    public ParameterNameMustBeFriendlyRule() {
        super("Parameter display name seems not to be a friendly name", "The displayName should be a human readable name separated with spaces.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endpointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, operationDescriptor, endpointDescriptor));
                results.addAll(this.validateParameterNames(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, operationDescriptor, endpointDescriptor));
            }
        }
        return results;
    }

    List<ValidationResult> validateParameterNames(List<ParameterDescriptor> parameters, ParameterType parameterType, OperationDescriptor operationDescriptor, EndPointDescriptor endpointDescriptor) {
        return parameters.stream().filter(x -> !NamingUtil.isFriendlyName(x.getFriendlyName())).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, (ParameterDescriptor)x, parameterType)).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ParameterType parameterType) {
        String location = "Operation Descriptor with PATH: " + endpointDescriptor.getPath() + " and METHOD: " + operationDescriptor.getMethod() + " declares a " + parameterType.getName() + " named " + parameterDescriptor.getFriendlyName() + " whose display name is : " + parameterDescriptor.getFriendlyName();
        return new ValidationResult(this, location);
    }
}

