/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TriggerPathAndMethodMustExistInApiRule
extends PreValidationRule {
    public TriggerPathAndMethodMustExistInApiRule() {
        super("Trigger PATH and METHOD must exist in the API specification.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List<TriggerDescriptor> triggerDescriptors = connectorDescriptor.getTriggers();
        if (triggerDescriptors != null && !triggerDescriptors.isEmpty()) {
            return triggerDescriptors.stream().filter(x -> !TriggerPathAndMethodMustExistInApiRule.hasMatchingOperation(apiModel.getOperationsModel(), x)).map(this::getValidationError).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean hasMatchingOperation(List<APIOperationModel> operations, TriggerDescriptor triggerDescriptor) {
        return operations.stream().anyMatch(x -> x.getHttpMethod().name().equalsIgnoreCase(triggerDescriptor.getMethod().getName()) && x.getPath().equalsIgnoreCase(triggerDescriptor.getPath()));
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String location = "Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName();
        return new ValidationResult(this, location);
    }
}

