/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.LinkedList;
import java.util.List;

public class TriggerUriParamsMustBeCompleteRule
extends PreValidationRule {
    public TriggerUriParamsMustBeCompleteRule() {
        super("All URI parameters must be have a binding in the Trigger Descriptor.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> results = new LinkedList<ValidationResult>();
        List<TriggerDescriptor> triggerDescriptors = connectorDescriptor.getTriggers();
        if (!triggerDescriptors.isEmpty()) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                List<APIParameterModel> uriParamsModel;
                APIOperationModel operationModel = this.getOperation(apiModel, triggerDescriptor);
                if (operationModel == null || (uriParamsModel = operationModel.getUriParamsModel()).size() <= triggerDescriptor.getParameterBindings().getUriParameters().size()) continue;
                results.add(this.getValidationError(triggerDescriptor));
            }
        }
        return results;
    }

    private APIOperationModel getOperation(APIModel apiModel, TriggerDescriptor triggerDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(triggerDescriptor.getPath())).filter(x -> x.getHttpMethod().name().equalsIgnoreCase(triggerDescriptor.getMethod().getName())).findFirst().orElse(null);
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String location = "Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName();
        return new ValidationResult(this, location);
    }
}

