/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverReferenceArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueResolverReferenceArgumentsOperationParameterExistsRule
extends PreValidationRule {
    private static final Pattern VALID_FORMAT_PATTERN = Pattern.compile("^(?:uriParameter\\.|queryParameter\\.|header\\.)\\S+$");
    private static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("^(uriParameter\\.|queryParameter\\.|header\\.)(\\S+)$");

    public ValueResolverReferenceArgumentsOperationParameterExistsRule() {
        super("All parameter references sent as argument to a value resolver must exist in the operation.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operation : endpoint.getOperations()) {
                validationResults.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getUriParameter(), apiModel, connectorDescriptor.getValueResolvers()));
                validationResults.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getQueryParameter(), apiModel, connectorDescriptor.getValueResolvers()));
                validationResults.addAll(this.validateOperationParameters(endpoint, operation, operation.getExpects().getHeader(), apiModel, connectorDescriptor.getValueResolvers()));
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validateOperationParameters(EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor, List<ParameterDescriptor> parameterDescriptors, APIModel apiModel, List<ValueResolverDescriptor> valueResolverDescriptors) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (ParameterDescriptor parameter : parameterDescriptors) {
            APIOperationModel apiOperationModel;
            if (parameter.getValueResolver() == null || parameter.getValueResolver().getArguments() == null || parameter.getValueResolver().getArguments().isEmpty() || valueResolverDescriptors.isEmpty() || valueResolverDescriptors.stream().noneMatch(x -> x.getName().equalsIgnoreCase(parameter.getValueResolver().getId())) || (apiOperationModel = this.findApiOperationModel(apiModel, endpointDescriptor, operationDescriptor)) == null) continue;
            validationResults.addAll(parameter.getValueResolver().getArguments().stream().filter(x -> this.validArgumentValueFormat(x.getValue())).filter(x -> !this.argumentParameterExistsInOperation(x.getValue(), apiOperationModel)).map(x -> this.getValidationError(endpointDescriptor, operationDescriptor, parameter, (ValueResolverReferenceArgumentDescriptor)x)).collect(Collectors.toList()));
        }
        return validationResults;
    }

    private APIOperationModel findApiOperationModel(APIModel apiModel, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(endpointDescriptor.getPath())).filter(x -> x.getHttpMethod().name().equalsIgnoreCase(operationDescriptor.getMethod())).findFirst().orElse(null);
    }

    private boolean validArgumentValueFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return VALID_FORMAT_PATTERN.matcher(value).matches();
    }

    private boolean argumentParameterExistsInOperation(String value, APIOperationModel apiOperationModel) {
        String parameterType = this.getParameterTypeReference(value);
        String parameterName = this.getParameterReference(value);
        if (parameterType == null || parameterName == null) {
            return false;
        }
        if (parameterType.startsWith("uriParameter")) {
            return apiOperationModel.getUriParamsModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        if (parameterType.startsWith("queryParameter")) {
            return apiOperationModel.getQueryParamsModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        if (parameterType.startsWith("header")) {
            return apiOperationModel.getHeadersModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        return false;
    }

    private String getParameterTypeReference(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Matcher matcher = PARAMETER_NAME_PATTERN.matcher(value);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getParameterReference(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Matcher matcher = PARAMETER_NAME_PATTERN.matcher(value);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private ValidationResult getValidationError(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ParameterDescriptor parameterDescriptor, ValueResolverReferenceArgumentDescriptor argument) {
        String location = "'" + parameterDescriptor.getParamName() + "' parameter declared for the operation with PATH '" + endPointDescriptor.getPath() + "' and METHOD: '" + operationDescriptor.getMethod() + "' on the connector descriptor referencing an invalid parameter for the argument '" + argument.getName() + "' : '" + argument.getValue() + "'";
        return new ValidationResult(this, location);
    }
}

